/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.WorkLogEntity;
import com.bringspring.extend.entity.WorkLogShareEntity;
import com.bringspring.extend.mapper.WorkLogMapper;
import com.bringspring.extend.service.WorkLogService;
import com.bringspring.extend.service.WorkLogShareService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkLogServiceImpl
extends ServiceImpl<WorkLogMapper, WorkLogEntity>
implements WorkLogService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private WorkLogShareService workLogShareService;

    @Override
    public List<WorkLogEntity> getSendList(Pagination pageModel) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(WorkLogEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        if (StringUtils.isNotEmpty((String)pageModel.getKeyword())) {
            queryWrapper.lambda().like(WorkLogEntity::getTitle, (Object)pageModel.getKeyword());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageModel.getSidx())) {
            queryWrapper.lambda().orderByDesc(WorkLogEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(pageModel.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pageModel.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pageModel.getSidx());
        }
        Page page = new Page(pageModel.getCurrentPage(), pageModel.getPageSize());
        IPage iPages = this.page((IPage)page, (Wrapper)queryWrapper);
        return pageModel.setData(iPages.getRecords(), page.getTotal());
    }

    @Override
    public List<WorkLogEntity> getReceiveList(Pagination pageModel) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(WorkLogEntity::getToUserId, (Object)this.userProvider.get().getUserId());
        if (StringUtils.isNotEmpty((String)pageModel.getKeyword())) {
            queryWrapper.lambda().like(WorkLogEntity::getTitle, (Object)pageModel.getKeyword());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageModel.getSidx())) {
            queryWrapper.lambda().orderByDesc(WorkLogEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(pageModel.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pageModel.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pageModel.getSidx());
        }
        Page page = new Page(pageModel.getCurrentPage(), pageModel.getPageSize());
        IPage iPages = this.page((IPage)page, (Wrapper)queryWrapper);
        return pageModel.setData(iPages.getRecords(), page.getTotal());
    }

    @Override
    public WorkLogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(WorkLogEntity::getId, (Object)id);
        return (WorkLogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(WorkLogEntity entity) {
        String[] toUserIds;
        entity.setId(RandomUtil.uuId());
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
        for (String userIds : toUserIds = entity.getToUserId().split(",")) {
            WorkLogShareEntity workLogShare = new WorkLogShareEntity();
            workLogShare.setId(RandomUtil.uuId());
            workLogShare.setShareTime(new Date());
            workLogShare.setWorkLogId(entity.getId());
            workLogShare.setShareUserId(userIds);
            this.workLogShareService.save(workLogShare);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, WorkLogEntity entity) {
        String[] toUserIds;
        boolean flag = false;
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        flag = this.updateById(entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(WorkLogShareEntity::getWorkLogId, (Object)entity.getId());
        this.workLogShareService.remove((Wrapper)queryWrapper);
        for (String userIds : toUserIds = entity.getToUserId().split(",")) {
            WorkLogShareEntity workLogShare = new WorkLogShareEntity();
            workLogShare.setId(RandomUtil.uuId());
            workLogShare.setShareTime(new Date());
            workLogShare.setWorkLogId(entity.getId());
            workLogShare.setShareUserId(userIds);
            this.workLogShareService.save(workLogShare);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public void delete(WorkLogEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            queryWrapper.lambda().eq(WorkLogShareEntity::getWorkLogId, (Object)entity.getId());
        }
        this.workLogShareService.remove((Wrapper)queryWrapper);
    }
}

