package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目计划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_projectgantt")
public class ProjectGanttEntity {
    /**
     * 项目主键
     */
    @TableId("ID")
    private String id;

    /**
     * 项目上级
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 项目主键
     */
    @TableField("PROJECTID")
    private String projectId;

    /**
     * 项目类型
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 项目编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 项目名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 项目工期
     */
    @TableField("TIMELIMIT")
    private BigDecimal timeLimit;

    /**
     * 项目标记
     */
    @TableField("SIGN")
    private String sign;

    /**
     * 标记颜色
     */
    @TableField("SIGNCOLOR")
    private String signColor;

    /**
     * 开始时间
     */
    @TableField("STARTTIME")
    private Date startTime;

    /**
     * 结束时间
     */
    @TableField("ENDTIME")
    private Date endTime;

    /**
     * 当前进度
     */
    @TableField("SCHEDULE")
    private Integer schedule;

    /**
     * 负责人
     */
    @TableField("MANAGER_IDS")
    private String managerIds;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
    /**
     * 项目状态(1-进行中，2-已暂停)
     */
    @TableField("State")
    private Integer state;
}
