package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单收款
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_orderreceivable")
public class OrderReceivableEntity {
    /**
     * 订单收款主键
     */
    @TableId("ID")
    private String id;

    /**
     * 订单主键
     */
    @TableField("ORDERID")
    private String orderId;

    /**
     * 收款摘要
     *
     */
    @TableField("ABSTRACT")
    private String fabstract;

    /**
     * 收款日期
     */
    @TableField("RECEIVABLEDATE")
    private Date receivableDate;

    /**
     * 收款比率
     */
    @TableField("RECEIVABLERATE")
    private BigDecimal receivableRate;

    /**
     * 收款金额
     */
    @TableField("RECEIVABLEMONEY")
    private BigDecimal receivableMoney;

    /**
     * 收款方式
     */
    @TableField("RECEIVABLEMODE")
    private String receivableMode;

    /**
     * 收款状态
     */
    @TableField("RECEIVABLESTATE")
    private Integer receivableState;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;
}
