package com.bringspring.extend.model.schedule;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class SchedulePcListVO {
    @ApiModelProperty(value = "日程主键")
    private String id;
    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endTime;
    @ApiModelProperty(value = "颜色")
    private String colour;
    @ApiModelProperty(value = "日程内容")
    private String content;

    @JsonProperty("creatorTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date creatorTime;

    @JsonProperty("title")
    private String title;

    //    状态
    @JsonProperty("state")
    private String state;

    private String time;
}
