package com.bringspring.extend.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.mapper.ScheduleMapper;
import com.bringspring.extend.model.schedule.SchedulePagination;
import com.bringspring.extend.service.ScheduleService;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 日程安排
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Service
public class ScheduleServiceImpl extends ServiceImpl<ScheduleMapper, ScheduleEntity> implements ScheduleService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;


    @Override
    public List<ScheduleEntity> getList(String startTime, String endTime) {
        QueryWrapper<ScheduleEntity> queryWrapper = new QueryWrapper<>();
        Date startTimes = DateUtil.stringToDates(startTime);
        Date endTimes = DateUtil.stringToDates(endTime);
        queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, userProvider.get().getUserId())
                .ge(ScheduleEntity::getStartTime, startTimes)
                .le(ScheduleEntity::getEndTime, endTimes)
                .orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScoped(String startTime, String endTime) {
        QueryWrapper<ScheduleEntity> queryWrapper = new QueryWrapper<>();
        Date startTimes = DateUtil.stringToDate(startTime);
        Date endTimes = DateUtil.stringToDate(endTime);
         queryWrapper.lambda()
                .ge(ScheduleEntity::getStartTime, startTimes)
                .le(ScheduleEntity::getEndTime, endTimes)
                .orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScopedAndUserId(String startTime, String endTime) {
        QueryWrapper<ScheduleEntity> queryWrapper = new QueryWrapper<>();
        Date startTimes = DateUtil.stringToDate(startTime);
        Date endTimes = DateUtil.stringToDate(endTime);
        queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, userProvider.get().getUserId())
                .ge(ScheduleEntity::getStartTime, startTimes)
                .le(ScheduleEntity::getEndTime, endTimes)
                .orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public ScheduleEntity getInfo(String id) {
        QueryWrapper<ScheduleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ScheduleEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void delete(ScheduleEntity entity) {
        this.removeById(entity.getId());
    }

    @Override
    public void create(ScheduleEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userProvider.get().getUserId());

        this.save(entity);
    }

    @Override
    public Boolean judgeScheduleTimeConflict(ScheduleEntity entity) {
        String s = DateUtil.dateFormatToDay(DateUtil.getNowDate(), "yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScopedAndUserId(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            for (ScheduleEntity scheduleEntity : list) {
                boolean b = DateUtil.hasOverlap(scheduleEntity.getStartTime(), scheduleEntity.getEndTime(), entity.getStartTime(), entity.getEndTime());
                if (b) {
                    return b;
                }
            }
        }
        return false;
    }

    @Override
    public boolean update(String id, ScheduleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        return this.updateById(entity);
    }

    /**
     * 发送站内信  企业微信
     *
     * @param userId
     * @param title
     * @param content
     * @param content
     * @throws
     */
    @Override
    public void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List<String> collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(50);
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(sysConfigService.getConfigByKeyName("scheduleMessage").getKeyValue());

        sentMessageForm.setTitle("站内信标题");
        sentMessageForm.setContent("站内信内容");
        sentMessageForm.setBodyText(new HashMap<>());
        Map<String, String> map = new HashMap<>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue() + url);
        // 关联产品
        sentMessageForm.setParameterMap(map);
        List<SentMessageForm> messageListAll = new ArrayList<>();
        messageListAll.add(sentMessageForm);
        try {
            // TODO 消息发送方式待修改
//            serviceUtil.sendMessage(messageListAll);
        } catch (Exception e) {
            log.error("发消息异常:" + e.getMessage());
//            e.printStackTrace();
        }
    }

    /**
     * 发送站内信  企业微信
     *
     * @param userId
     * @throws
     */
    @Override
    public void sendFinishMessage(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId,String termType,String typeDesc) throws Exception {
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        linkMsgKeys.setLinkUrl(sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue());
        CustomKeysLink customKeysLink = new CustomKeysLink();
        //消息链接多端类型 1:支持app端;2:支持pc端;3:支持app和pc端
        customKeysLink.setTermType(termType);
//            消息链接多端类型 提示内容
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
//        customKeysLink.setAppUrl(appUrl);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey(linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            sendTaskMsgUtils.sendTaskMsg(taskMsg);
        } catch (Exception e) {
            log.error("发送消息异常:" + e.getMessage());
            e.printStackTrace();
        }
//        List<String> collect = userId.stream().distinct().collect(Collectors.toList());
//        SentMessageForm sentMessageForm = new SentMessageForm();
//        sentMessageForm.setType(230);
////        获取发消息模板
//        QueryWrapper<MessageTemplateEntity> templateEntityQueryWrapper = new QueryWrapper<>();
//        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, "scheduleMessage");
//        MessageTemplateEntity one = messageTemplateService.getOne(templateEntityQueryWrapper);
////        判断发消息模板，是否存在
//        if (ObjectUtil.isNotEmpty(one)) {
//            sentMessageForm.setTemplateId(one.getId());
//        }
//        // 消息时间
//        String messageTime = DateUtil.dateFormat(new Date());
////        发消息的用户id
//        sentMessageForm.setToUserIds(collect);
//        sentMessageForm.setTitle("工作签提醒：" + title);
//        //        如果内容为空，则展示标题值
//        if (StringUtils.isNotEmpty(sentMessageForm.getContent())){
//            sentMessageForm.setContent("内容："+content+"\n时间:" + messageTime);
//        }else{
//            sentMessageForm.setContent("内容："+title+"\n时间:" + messageTime);
//        }
//
//        Map<String, String> map = new HashMap<>();
//        map.put("title", title);
////        如果内容为空，则展示标题值
//        map.put("content", sentMessageForm.getContent());
//        map.put("MessageTime", messageTime);
//        map.put("PcUrl", url);
//        // 关联产品
//        sentMessageForm.setParameterMap(map);
//        sentMessageForm.setBodyText(map);
//        List<SentMessageForm> messageListAll = new ArrayList<>();
//        messageListAll.add(sentMessageForm);
//
//        serviceUtil.sendMessage(messageListAll);
    }

    @Override
    public void scheduledRemindeMorning() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (!scheduleEntities.isEmpty()) {
                    List<String> userids = new ArrayList<>();
                    userids.add(scheduleEntities.get(0).getCreatorUserId());
                    //app端路径
                    String url = "/#";
                    String content="";
                    for (int i = 0; i < scheduleEntities.size(); i++) {
                        if (i != scheduleEntities.size() - 1) {
                            content+=scheduleEntities.get(i).getTitle()+"\n";
                        }else {
                            content+=scheduleEntities.get(i).getTitle();
                        }
                    }
                    this.sendMessage(userids, "您今日有"+scheduleEntities.size()+"个日程！", content, url);
                }
            }
        }


    }

    @Override
    public void scheduledRemindeEvery() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (!scheduleEntities.isEmpty()) {
                    for (ScheduleEntity scheduleEntity : scheduleEntities) {
//                        判断工作签  提前十分钟提醒   只提醒一次，
                        if (DateUtil.getNowDate().getTime()-scheduleEntity.getStartTime().getTime()<=600000) {
                            List<String> userids = new ArrayList<>();
                            userids.add(scheduleEntity.getCreatorUserId());
                            //app端路径
                            String url = "/#/";
                            this.sendMessage(userids, "您有日程"+scheduleEntity.getTitle()+"快开始了", scheduleEntity.getContent(), url);
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<ScheduleEntity> getListPagination(SchedulePagination schedulePagination)throws Exception{

        List<String> AllIdList =new ArrayList();
        int total=0;

        QueryWrapper<ScheduleEntity> queryWrapper = new QueryWrapper<>();


        if(AllIdList.size()>0){
            queryWrapper.lambda().in(ScheduleEntity::getId, AllIdList);
        }

        //        提交时间范围
        if (schedulePagination.getStartTime()!=null && schedulePagination.getStartTime().size()>0 ){
            schedulePagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getStartTime().get(0))));
            schedulePagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getStartTime().get(1)+86400000)));
            queryWrapper.lambda().between(ScheduleEntity::getStartTime,schedulePagination.getStartTimes(),schedulePagination.getEndTime());
        }
        //        创建时间范围
        if (schedulePagination.getCreationTime()!=null && schedulePagination.getCreationTime().size()>0 ){
            schedulePagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getCreationTime().get(0))));
            schedulePagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getCreationTime().get(1)+86400000)));
            queryWrapper.lambda().between(ScheduleEntity::getCreatorTime,schedulePagination.getStartTimes(),schedulePagination.getEndTime());
        }
//        时间选择
        if (StringUtils.isNotEmpty(schedulePagination.getCurrentDate())){
            String replacedString = schedulePagination.getCurrentDate().replace("-", "/");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            Date date = formatter.parse(replacedString);
            queryWrapper.lambda().between(ScheduleEntity::getStartTime,schedulePagination.getCurrentDate()
                    ,formatter.format(new Date(date.getTime()+86400000)));
        }
//        工作时间选择
        if (StringUtils.isNotEmpty(schedulePagination.getEndTime())){
            queryWrapper.between("endTime",
                    LocalDate.parse(schedulePagination.getEndTime()).atStartOfDay(),
                    LocalDate.parse(schedulePagination.getEndTime()).atTime(LocalTime.MAX));
        }
//        关键字查询
        if (StringUtils.isNotEmpty(schedulePagination.getKeyword())){
            queryWrapper.lambda().like(ScheduleEntity::getTitle, schedulePagination.getKeyword());
        }
//        状态
        if (StringUtils.isNotEmpty(schedulePagination.getState())){
            queryWrapper.lambda().eq(ScheduleEntity::getState, schedulePagination.getState());
        }
        queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, userProvider.get().getUserId())
                .orderByAsc(ScheduleEntity::getCreatorTime);

        if((total>0 && AllIdList.size()>0) || total==0){
            Page<ScheduleEntity> page=new Page<>(schedulePagination.getCurrentPage(), schedulePagination.getPageSize());
            IPage<ScheduleEntity> userIPage=this.page(page, queryWrapper);
            return schedulePagination.setData(userIPage.getRecords(),userIPage.getTotal());
        }else{
            List<ScheduleEntity> list = new ArrayList();
            return schedulePagination.setData(list, list.size());
        }
    }

    @Override
    public List<ScheduleEntity> getDateList(SchedulePagination schedulePagination) {
        LambdaQueryWrapper<ScheduleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ScheduleEntity::getCreatorUserId, userProvider.get().getUserId())
                .eq(ScheduleEntity::getState,"0").select(ScheduleEntity::getStartTime,ScheduleEntity::getEndTime)
                .orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public void scheduledfinishEvery() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (!scheduleEntities.isEmpty()) {
                    for (ScheduleEntity scheduleEntity : scheduleEntities) {
//                        判断工作签  结束提前十分钟提醒   只提醒一次，
                        if (scheduleEntity.getStartTime().getTime()<=DateUtil.getNowDate().getTime() && scheduleEntity.getSendNumber() < 1) {
//                            提醒次数加1，现在只提醒一次
                            scheduleEntity.setSendNumber(1);
                            scheduleService.update(scheduleEntity.getId(),scheduleEntity);//修改
//                            String url = "https://gl.bringspring.com/jsbos-web/#/views/oa/schedule";

                            //消息时间
                            String messageTime = DateUtil.dateFormat(new Date());
                            String title= "您有日程"+scheduleEntity.getTitle()+"快结束了";
                            String content= "";
                             //        如果内容为空，则展示标题值
                            if (StringUtils.isNotEmpty(scheduleEntity.getContent())){
                                content="内容："+scheduleEntity.getContent()+"\n时间:" + messageTime;
                            }else{
                                content="内容："+title+"\n时间:" + messageTime;
                             }
                            HashMap<String, String> keys = new HashMap<>();
                            keys.put("title", title);
                         // 如果内容为空，则展示标题值
                            keys.put("content", content);
                            String pcUrl= "/#/oa/schedule";
                            String userId = scheduleEntity.getCreatorUserId();
                            String type= TermTypeEnum.TERM_PC.getCode();
                            String typeDesc= "请用pc端打开链接，进行信息确认”";
                            this.sendFinishMessage("日程提醒","scheduleMessage",keys,null,null,pcUrl,userId,type,typeDesc);
                        }
                    }
                }
            }
        }
    }


    //每天8：30提醒当天所有日程
    public Map<String, List<ScheduleEntity>> getMapByTime() {
        String s = DateUtil.dateFormatToDay(DateUtil.getNowDate(), "yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScoped(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            Map<String, List<ScheduleEntity>> map = list.stream().collect(Collectors.groupingBy(ScheduleEntity::getCreatorUserId));
            return map;
        }
        return null;
    }
}
