package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 职员信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 *
 */
@Data
@TableName("ext_employee")
public class EmployeeEntity {
    /**
     * 职员主键
     */
    @TableId("ID")
    private String id;

    /**
     * 工号
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 姓名
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 性别
     */
    @TableField("GENDER")
    private String gender;

    /**
     * 部门
     */
    @TableField("DEPARTMENTNAME")
    private String departmentName;

    /**
     * 岗位
     */
    @TableField("POSITIONNAME")
    private String positionName;

    /**
     * 用工性质
     */
    @TableField("WORKINGNATURE")
    private String workingNature;

    /**
     * 身份证号
     */
    @TableField("IDNUMBER")
    private String idNumber;

    /**
     * 联系电话
     */
    @TableField("TELEPHONE")
    private String telephone;

    /**
     * 参加工作
     */
    @TableField("ATTENDWORKTIME")
    private Date attendWorkTime;

    /**
     * 出生年月
     */
    @TableField("BIRTHDAY")
    private Date birthday;

    /**
     * 最高学历
     */
    @TableField("EDUCATION")
    private String education;

    /**
     * 所学专业
     */
    @TableField("MAJOR")
    private String major;

    /**
     * 毕业院校
     */
    @TableField("GRADUATIONACADEMY")
    private String graduationAcademy;

    /**
     * 毕业时间
     */
    @TableField("GRADUATIONTIME")
    private Date graduationTime;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
