package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.StringUtils;
import com.bringspring.extend.entity.ProductEntryEntity;
import com.bringspring.extend.mapper.ProductEntryMapper;
import com.bringspring.extend.service.ProductEntryService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 销售订单明细
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-07-10 10:40:59
 */
@Service
public class ProductEntryServiceImpl extends ServiceImpl<ProductEntryMapper, ProductEntryEntity> implements ProductEntryService {

    @Override
    public List<ProductEntryEntity> getProductentryEntityList(String id) {
        QueryWrapper<ProductEntryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProductEntryEntity::getProductId, id);
        return this.list(queryWrapper);
    }

    @Override
    public List<ProductEntryEntity> getProductentryEntityList(Pagination pagination) {
        QueryWrapper<ProductEntryEntity> queryWrapper = new QueryWrapper<>();
        if(StringUtils.isNotEmpty(pagination.getKeyword())){
            queryWrapper.lambda().and(
                    t->t.like(ProductEntryEntity::getProductName, pagination.getKeyword())
                        .or().like(ProductEntryEntity::getProductCode, pagination.getKeyword())
                        .or().like(ProductEntryEntity::getProductSpecification, pagination.getKeyword())
            );
        }
        Page<ProductEntryEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<ProductEntryEntity> userIPage = this.page(page, queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

}