package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.Page;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FileModel;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.extend.model.documentpreview.FileListVO;
import com.bringspring.files.enums.FilePreviewTypeEnum;
import com.bringspring.files.model.YozoFileParams;
import com.bringspring.files.model.YozoParams;
import com.bringspring.files.utils.SplicingUrlUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.stream.Collectors;

;

/**
 * 文档在线预览
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@NoDataSourceBind()
@Tag(name = "文档在线预览", description = "文档在线预览功能管理")
@RestController
@RequestMapping("/api/extend/DocumentPreview")
public class DocumentPreviewController {

    @Autowired
    private ConfigValueUtil configValueUtil;

    /**
     * 列表
     *
     * @param page
     * @return
     */
    @Operation(summary="获取文档列表")
    @GetMapping
    public ActionResult<List<FileListVO>> list(Page page) {
        String path = configValueUtil.getDocumentPreviewPath();
        List<FileModel> data = UploadUtil.getFileList(configValueUtil.getFileType(), FileTypeEnum.DOCUMENTPREVIEWPATH, path, page.getKeyword(), true);
        List<FileListVO> list = JsonUtil.getJsonToList(data, FileListVO.class);
        return ActionResult.success(list);
    }

    /**
     * 文档预览
     *
     * @param fileId 文件标记
     * @return
     */
    @Operation(summary="文档在线预览")
    @GetMapping("/{fileId}/Preview")
    public ActionResult list(@PathVariable("fileId") Integer fileId, YozoFileParams params, String previewType) throws UnsupportedEncodingException {
        File file = null;
        String filePath = configValueUtil.getDocumentPreviewPath();
        if (configValueUtil.getFileType().equals("minio")){
            //下载到本地
            List<FileModel> fileList = UploadUtil.getFileList(configValueUtil.getFileType(), FileTypeEnum.DOCUMENTPREVIEWPATH, filePath, null, false);
            if (fileList.get(fileId) == null){
                return ActionResult.fail("文件找不到!");
            }
            String url = YozoParams.DOMAINS + "/api/extend/DocumentPreview/down/" + fileList.get(fileId).getFileName();
            String urlPath;
            if (previewType.equals(FilePreviewTypeEnum.YOZO_ONLINE_PREVIEW.getType())){
                params.setUrl(url);
                urlPath = SplicingUrlUtil.getPreviewUrl(params);
                return ActionResult.success("success", XSSEscape.escape(urlPath));
            }
            if(previewType.equals(FilePreviewTypeEnum.LOCAL_PREVIEW.getType())){
                return ActionResult.success("success",url);
            }

        }else {
            File filePaths = new File(XSSEscape.escapePath(filePath));
            List<File> files = FileUtil.getFile(filePaths);
            if (fileId > files.size()) {
                return ActionResult.fail("文件找不到!");
            }
            file = files.get(fileId);
            if (file != null) {
                String url = YozoParams.DOMAINS + "/api/extend/DocumentPreview/down/" + file.getName();
                String urlPath;
                if (previewType.equals(FilePreviewTypeEnum.YOZO_ONLINE_PREVIEW.getType())){
                    params.setUrl(url);
                    urlPath = SplicingUrlUtil.getPreviewUrl(params);
                    return ActionResult.success("success", XSSEscape.escape(urlPath));
                }
                if(previewType.equals(FilePreviewTypeEnum.LOCAL_PREVIEW.getType())){
                    return ActionResult.success("success",url);
                }
            }
        }
        return ActionResult.fail("文件找不到!");
    }

    /**
     * 下载文件
     *
     * @param fileName
     */
    @NoDataSourceBind
    @GetMapping("/down/{fileName}")
    public void down(@PathVariable("fileName") String fileName) throws DataException {
        String filePath = configValueUtil.getDocumentPreviewPath();
        //下载文件
        List<FileModel> fileList = UploadUtil.getFileList(configValueUtil.getFileType(), FileTypeEnum.DOCUMENTPREVIEWPATH, filePath, null, false);
        //判断文件是否存在
        List<FileModel> collect = fileList.stream().filter(t -> fileName.equals(t.getFileName())).collect(Collectors.toList());
        if (collect.size() > 0){
            UploadUtil.streamToDown(configValueUtil.getFileType(), fileName, FileTypeEnum.DOCUMENTPREVIEWPATH, filePath);
        }
        filePath += fileName;
        if (FileUtil.fileIsFile(filePath)) {
            if (!DownUtil.dowloadFile(filePath, fileName, null)) {
                throw new DataException("下载失败");
            }
        }
    }

}
