

package com.bringspring.extend.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.bringspring.extend.model.documenthistory.*;
import com.bringspring.extend.service.DocumentHistoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;

/**
 * 知识文档
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2023-09-22
 */
@Slf4j
@RestController
@Tag(name = "知识文档", description = "知识文档历史记录管理")
@RequestMapping("/api/document/ExtDocumentHistory")
public class ExtDocumentHistoryController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private DocumentHistoryService documentHistoryService;


    /**
     * 列表
     *
     * @param documentHistoryPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody DocumentHistoryPagination documentHistoryPagination) throws IOException {
        List<DocumentHistoryEntity> list = documentHistoryService.getList(documentHistoryPagination);
        //处理id字段转名称，若无需转或者为空可删除
        for (DocumentHistoryEntity entity : list) {
            entity.setCreatorUserId(baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        }
        List<DocumentHistoryListVO> listVO = JsonUtil.getJsonToList(list, DocumentHistoryListVO.class);
        for (DocumentHistoryListVO extDocumentHistoryVO : listVO) {
        }


        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(documentHistoryPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param documentHistoryCrForm
     * @return
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DocumentHistoryCrForm documentHistoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = userProvider.get();
        documentHistoryCrForm.setCreatorUserId(userInfo.getUserId());
        documentHistoryCrForm.setCreatorTime(DateUtil.getNow());
        DocumentHistoryEntity entity = JsonUtil.getJsonToBean(documentHistoryCrForm, DocumentHistoryEntity.class);
        entity.setId(mainId);
        documentHistoryService.save(entity);


        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<DocumentHistoryInfoVO> info(@PathVariable("id") String id) {
        DocumentHistoryEntity entity = documentHistoryService.getInfo(id);
        DocumentHistoryInfoVO vo = JsonUtil.getJsonToBean(entity, DocumentHistoryInfoVO.class);
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }

        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<DocumentHistoryInfoVO> detailInfo(@PathVariable("id") String id) {
        DocumentHistoryEntity entity = documentHistoryService.getInfo(id);
        DocumentHistoryInfoVO vo = JsonUtil.getJsonToBean(entity, DocumentHistoryInfoVO.class);

        //子表数据转换

        //附表数据转换

//添加到详情表单对象中
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));

        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    @DSTransactional
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid DocumentHistoryUpForm documentHistoryUpForm) throws DataException {
        UserInfo userInfo = userProvider.get();
        DocumentHistoryEntity entity = documentHistoryService.getInfo(id);
        if (entity != null) {
            DocumentHistoryEntity subentity = JsonUtil.getJsonToBean(documentHistoryUpForm, DocumentHistoryEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            documentHistoryService.update(id, subentity);
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @DSTransactional
    public ActionResult delete(@PathVariable("id") String id) {
        DocumentHistoryEntity entity = documentHistoryService.getInfo(id);
        if (entity != null) {
            documentHistoryService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


}
