package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_order")
public class OrderEntity {
    /**
     * 订单主键
     */
    @TableId("ID")
    private String id;

    /**
     * 客户Id
     */
    @TableField("CUSTOMERID")
    private String customerId;

    /**
     * 客户名称
     */
    @TableField("CUSTOMERNAME")
    private String customerName;

    /**
     * 业务员Id
     */
    @TableField("SALESMANID")
    private String salesmanId;

    /**
     * 业务员
     */
    @TableField("SALESMANNAME")
    private String salesmanName;

    /**
     * 订单日期
     */
    @TableField("ORDERDATE")
    private Date orderDate;

    /**
     * 订单编码
     */
    @TableField("ORDERCODE")
    private String orderCode;

    /**
     * 运输方式
     */
    @TableField("TRANSPORTMODE")
    private String transportMode;

    /**
     * 发货日期
     */
    @TableField("DELIVERYDATE")
    private Date deliveryDate;

    /**
     * 发货地址
     */
    @TableField("DELIVERYADDRESS")
    private String deliveryAddress;

    /**
     * 付款方式
     */
    @TableField("PAYMENTMODE")
    private String paymentMode;

    /**
     * 应收金额
     */
    @TableField("RECEIVABLEMONEY")
    private BigDecimal receivableMoney;

    /**
     * 定金比率
     */
    @TableField("EARNESTRATE")
    private BigDecimal earnestRate;

    /**
     * 预付定金
     */
    @TableField("PREPAYEARNEST")
    private BigDecimal prepayEarnest;

    /**
     * 当前状态
     */
    @TableField("CURRENTSTATE")
    private Integer currentState;

    /**
     * 附件信息
     */
    @TableField("FILEJSON")
    private String fileJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志 1-正常、0-作废
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
