package com.bringspring.extend.model.projectgantt;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 10:21
 */
@Data
public class ProjectGanttCrForm {

    @NotNull(message = "必填")
    @Schema(description = "完成进度")
    private Integer schedule;

    @NotBlank(message = "必填")
    @Schema(description = "项目名称")
    private String fullName;

    @NotBlank(message = "必填")
    @Schema(description = "项目编码")
    private String enCode;

    @NotBlank(message = "必填")
    @Schema(description = "参与人员")
    private String managerIds;

    @NotNull(message = "必填")
    @Schema(description = "开始时间")
    private long startTime;

    @NotNull(message = "必填")
    @Schema(description = "结束时间")
    private long endTime;

    @NotNull(message = "必填")
    @Schema(description = "项目工期")
    private BigDecimal timeLimit;

    @Schema(description = "项目描述")
    private String description;

    @Schema(description = "项目状态")
    private Integer state;

}
