package com.bringspring.extend.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.exception.DataException;
import com.bringspring.extend.entity.ProductEntity;
import com.bringspring.extend.entity.ProductEntryEntity;
import com.bringspring.extend.model.product.ProductPagination;

import java.util.List;

/**
 * 销售订单
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-07-10 10:40:59
 */
public interface ProductService extends IService<ProductEntity> {

    List<ProductEntity> getList(ProductPagination productPagination);

    ProductEntity getInfo(String id);

    void delete(ProductEntity entity);

    void create(ProductEntity entity, List<ProductEntryEntity> productEntryList ) throws DataException;

    boolean update(String id, ProductEntity entity, List<ProductEntryEntity> productEntryList );

}
