/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.mapper.ScheduleMapper;
import com.bringspring.extend.model.schedule.SchedulePagination;
import com.bringspring.extend.service.ScheduleService;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
extends ServiceImpl<ScheduleMapper, ScheduleEntity>
implements ScheduleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @Override
    public List<ScheduleEntity> getList(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDates((String)startTime);
        Date endTimes = DateUtil.stringToDates((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScoped(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDate((String)startTime);
        Date endTimes = DateUtil.stringToDate((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScopedAndUserId(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDate((String)startTime);
        Date endTimes = DateUtil.stringToDate((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ScheduleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ScheduleEntity::getId, (Object)id);
        return (ScheduleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(ScheduleEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(ScheduleEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public Boolean judgeScheduleTimeConflict(ScheduleEntity entity) {
        String s = DateUtil.dateFormatToDay((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScopedAndUserId(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            for (ScheduleEntity scheduleEntity : list) {
                boolean b = DateUtil.hasOverlap((Date)scheduleEntity.getStartTime(), (Date)scheduleEntity.getEndTime(), (Date)entity.getStartTime(), (Date)entity.getEndTime());
                if (!b) continue;
                return b;
            }
        }
        return false;
    }

    @Override
    public boolean update(String id, ScheduleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(50));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("scheduleMessage").getKeyValue());
        sentMessageForm.setTitle("\u7ad9\u5185\u4fe1\u6807\u9898");
        sentMessageForm.setContent("\u7ad9\u5185\u4fe1\u5185\u5bb9");
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue() + url);
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    @Override
    public void sendFinishMessage(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc) throws Exception {
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        linkMsgKeys.setLinkUrl(this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue());
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(termType);
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            this.log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void scheduledRemindeMorning() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (scheduleEntities.isEmpty()) continue;
                ArrayList<String> userids = new ArrayList<String>();
                userids.add(scheduleEntities.get(0).getCreatorUserId());
                String url = "/#";
                Object content = "";
                for (int i = 0; i < scheduleEntities.size(); ++i) {
                    content = i != scheduleEntities.size() - 1 ? (String)content + scheduleEntities.get(i).getTitle() + "\n" : (String)content + scheduleEntities.get(i).getTitle();
                }
                this.sendMessage(userids, "\u60a8\u4eca\u65e5\u6709" + scheduleEntities.size() + "\u4e2a\u65e5\u7a0b\uff01", (String)content, url);
            }
        }
    }

    @Override
    public void scheduledRemindeEvery() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (scheduleEntities.isEmpty()) continue;
                for (ScheduleEntity scheduleEntity : scheduleEntities) {
                    if (DateUtil.getNowDate().getTime() - scheduleEntity.getStartTime().getTime() > 600000L) continue;
                    ArrayList<String> userids = new ArrayList<String>();
                    userids.add(scheduleEntity.getCreatorUserId());
                    String url = "/#/";
                    this.sendMessage(userids, "\u60a8\u6709\u65e5\u7a0b" + scheduleEntity.getTitle() + "\u5feb\u5f00\u59cb\u4e86", scheduleEntity.getContent(), url);
                }
            }
        }
    }

    @Override
    public List<ScheduleEntity> getListPagination(SchedulePagination schedulePagination) throws Exception {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(ScheduleEntity::getId, AllIdList);
        }
        if (schedulePagination.getStartTime() != null && schedulePagination.getStartTime().size() > 0) {
            schedulePagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getStartTime().get(0))));
            schedulePagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getStartTime().get(1) + 86400000L)));
            queryWrapper.lambda().between(ScheduleEntity::getStartTime, (Object)schedulePagination.getStartTimes(), (Object)schedulePagination.getEndTime());
        }
        if (schedulePagination.getCreationTime() != null && schedulePagination.getCreationTime().size() > 0) {
            schedulePagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getCreationTime().get(0))));
            schedulePagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(schedulePagination.getCreationTime().get(1) + 86400000L)));
            queryWrapper.lambda().between(ScheduleEntity::getCreatorTime, (Object)schedulePagination.getStartTimes(), (Object)schedulePagination.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)schedulePagination.getCurrentDate())) {
            String replacedString = schedulePagination.getCurrentDate().replace("-", "/");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            Date date = formatter.parse(replacedString);
            queryWrapper.lambda().between(ScheduleEntity::getStartTime, (Object)schedulePagination.getCurrentDate(), (Object)formatter.format(new Date(date.getTime() + 86400000L)));
        }
        if (StringUtils.isNotEmpty((String)schedulePagination.getKeyword())) {
            queryWrapper.lambda().like(ScheduleEntity::getTitle, (Object)schedulePagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)schedulePagination.getState())) {
            queryWrapper.lambda().eq(ScheduleEntity::getState, (Object)schedulePagination.getState());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).orderByAsc(ScheduleEntity::getCreatorTime);
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(schedulePagination.getCurrentPage(), schedulePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return schedulePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return schedulePagination.setData(list, list.size());
    }

    @Override
    public List<ScheduleEntity> getDateList(SchedulePagination schedulePagination) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(ScheduleEntity::getState, (Object)"0")).select(new SFunction[]{ScheduleEntity::getStartTime}).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void scheduledfinishEvery() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (CollectionUtil.isNotEmpty(mapByTime)) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (scheduleEntities.isEmpty()) continue;
                for (ScheduleEntity scheduleEntity : scheduleEntities) {
                    if (scheduleEntity.getStartTime().getTime() > DateUtil.getNowDate().getTime() || scheduleEntity.getSendNumber() >= 1) continue;
                    scheduleEntity.setSendNumber(1);
                    this.scheduleService.update(scheduleEntity.getId(), scheduleEntity);
                    String messageTime = DateUtil.dateFormat((Date)new Date());
                    String title = "\u60a8\u6709\u65e5\u7a0b" + scheduleEntity.getTitle() + "\u5feb\u7ed3\u675f\u4e86";
                    Object content = "";
                    content = StringUtils.isNotEmpty((String)scheduleEntity.getContent()) ? "\u5185\u5bb9\uff1a" + scheduleEntity.getContent() + "\n\u65f6\u95f4:" + messageTime : "\u5185\u5bb9\uff1a" + title + "\n\u65f6\u95f4:" + messageTime;
                    HashMap<String, String> keys = new HashMap<String, String>();
                    keys.put("title", title);
                    keys.put("content", (String)content);
                    String pcUrl = "/#/oa/schedule";
                    String userId = scheduleEntity.getCreatorUserId();
                    String type = TermTypeEnum.TERM_PC.getCode();
                    String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4\u201d";
                    this.sendFinishMessage("\u65e5\u7a0b\u63d0\u9192", "scheduleMessage", keys, null, null, pcUrl, userId, type, typeDesc);
                }
            }
        }
    }

    public Map<String, List<ScheduleEntity>> getMapByTime() {
        String s = DateUtil.dateFormatToDay((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScoped(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            Map<String, List<ScheduleEntity>> map = list.stream().collect(Collectors.groupingBy(ScheduleEntity::getCreatorUserId));
            return map;
        }
        return null;
    }
}

