package com.bringspring.extend.controller;


import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.ZxingCodeUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.awt.image.BufferedImage;

/**
 * 生成条码
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Tag(name = "生成条码", description = "条码生成功能")
@RestController
@RequestMapping("/api/extend/BarCode")
public class BarCodeController {

    /**
     * 生成二维码
     *
     * @return
     */
    @Operation(summary="生成二维码")
    @GetMapping("/BuildQRCode")
    public void buildQrCode() {
        BufferedImage image = ZxingCodeUtil.createCode(ServletUtils.getHeader("QRCodeContent"), 400, 400);
        DownUtil.write(image);
    }

    /**
     * 生成条形码
     *
     * @return
     */
    @Operation(summary="生成条形码")
    @GetMapping("/BuildBarCode")
    public void buildBarCode() {
        BufferedImage image = ZxingCodeUtil.getBarcode(ServletUtils.getHeader("BarCodeContent"), 265, 50);
        DownUtil.write(image);
    }
}
