package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 知识文档
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_document")
public class DocumentEntity {
    /**
     * 文档主键
     */
    @TableId("ID")
    private String id;

    /**
     * 文档父级
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 文档分类
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 文件名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 文件路径
     */
    @TableField("FILE_PATH")
    private String filePath;

    /**
     * 文件大小
     */
    @TableField("FILE_SIZE")
    private String fileSize;

    /**
     * 文件后缀
     */
    @TableField("FILE_EXTENSION")
    private String fileExtension;

    /**
     * 阅读数量
     */
    @TableField("READE_COUNT")
    private Integer readcCount;

    /**
     * 是否共享
     */
    @TableField("IS_SHARE")
    private Integer isShare;

    /**
     * 是否公共文件
     */
    @TableField("IS_PUBLIC")
    private String isPublic;

    /**
     * 共享时间
     */
    @TableField("SHARE_TIME")
    private Date shareTime;

    @TableField("FILE_VERSION")
    private String fileVersion;

    /**
     * 摘要
     */
    @TableField("DESCRIPTION")
    private String description;
    /** 公司ID */
    @TableField("COMPANY_Id")
    private String companyId;
    /** 文档类型 */
    @TableField("FILE_TYPE")
    private String fileType;
    /** 文件标签 */
    @TableField("FILE_LABLE")
    private String fileLable;
    /** 关联产品 */
    @TableField("ASSOCIATION_PRODUCT")
    private String associationProduct;
    /** 公开类型 */
    @TableField("DISCLOSURE_TYPE")
    private String disclosureType;



    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
