package com.bringspring.extend.utils;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.extend.service.DocumentService;
import com.bringspring.extend.service.ScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduleTask {
    Logger logger = LoggerFactory.getLogger(ScheduleTask.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private DocumentService documentService;

    @JsbosTask(fullName = "每天8：30提醒当天所有日程", description = "每天8：30提醒当天所有日程")
    public void scheduledRemindeMorning() throws Exception {
        logger.info("每天8：30提醒当天所有日程");
        scheduleService.scheduledRemindeMorning();
    }

    @JsbosTask(fullName = "日程开始前15分钟提醒", description = "每天8：30提日程开始前15分钟提醒" ,cron = "0 2 * * * ?")
    public void scheduledRemindeEvery() throws Exception {
        logger.info("日程开始前15分钟提醒每天8：30提醒当天所有日程");
        scheduleService.scheduledRemindeEvery();
    }

    @JsbosTask(fullName = "日程结束前10分钟提醒", description = "每天8：30提日程开始前15分钟提醒" ,cron = "0 0/1 * * * ?")
    public void scheduledfinishEvery() throws Exception {
        logger.info("日程准时提醒");
        scheduleService.scheduledfinishEvery();
    }

    @JsbosTask(fullName = "清空临时下载目录", description = "每天凌晨2点清空")
    public void clearTemproryZip() throws Exception {
        logger.info("清空临时下载目录");
        documentService.clearDoc();
    }

}
