/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.ProductEntity;
import com.bringspring.extend.entity.ProductEntryEntity;
import com.bringspring.extend.model.product.ProductCrForm;
import com.bringspring.extend.model.product.ProductInfoVO;
import com.bringspring.extend.model.product.ProductListVO;
import com.bringspring.extend.model.product.ProductPagination;
import com.bringspring.extend.model.product.ProductUpForm;
import com.bringspring.extend.model.productEntry.ProductEntryInfoVO;
import com.bringspring.extend.model.productEntry.ProductEntryListVO;
import com.bringspring.extend.model.productEntry.ProductEntryMdoel;
import com.bringspring.extend.service.ProductEntryService;
import com.bringspring.extend.service.ProductService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u9500\u552e\u8ba2\u5355", description="\u9500\u552e\u8ba2\u5355\u4ea7\u54c1\u7ba1\u7406")
@RequestMapping(value={"/api/extend/saleOrder/Product"})
public class ProductController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProductController.class);
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductEntryService productEntryService;

    @Operation(summary="\u5217\u8868")
    @GetMapping
    public ActionResult list(ProductPagination productPagination) {
        List<ProductEntity> list = this.productService.getList(productPagination);
        List listVO = JsonUtil.getJsonToList(list, ProductListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)productPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ProductCrForm productCrForm) throws DataException {
        ProductEntity entity = (ProductEntity)JsonUtil.getJsonToBean((Object)productCrForm, ProductEntity.class);
        List productEntryList = JsonUtil.getJsonToList(productCrForm.getProductEntryList(), ProductEntryEntity.class);
        this.productService.create(entity, productEntryList);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ProductInfoVO> info(@PathVariable(value="id") String id) {
        ProductEntity entity = this.productService.getInfo(id);
        ProductInfoVO vo = (ProductInfoVO)JsonUtil.getJsonToBean((Object)entity, ProductInfoVO.class);
        List<ProductEntryEntity> productEntryList = this.productEntryService.getProductentryEntityList(id);
        List productList = JsonUtil.getJsonToList(productEntryList, ProductEntryInfoVO.class);
        vo.setProductEntryList(productList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ProductUpForm productUpForm) {
        ProductEntity entity = this.productService.getInfo(id);
        if (entity != null) {
            List productEntryList = JsonUtil.getJsonToList(productUpForm.getProductEntryList(), ProductEntryEntity.class);
            this.productService.update(id, entity, productEntryList);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @Operation(summary="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ProductEntity entity = this.productService.getInfo(id);
        if (entity != null) {
            this.productService.delete(entity);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @Operation(summary="\u83b7\u53d6\u9500\u552e\u660e\u7ec6")
    @GetMapping(value={"/ProductEntry/{id}"})
    public ActionResult<ListVO<ProductEntryInfoVO>> ProductEntryList(@PathVariable(value="id") String id) {
        String data = "[{\"id\":\"37c995b4044541009fb7e285bcf9845d\",\"productSpecification\":\"120ml\",\"qty\":16,\"money\":510,\"price\":120,\"commandType\":\"\u552f\u4e00\u7801\",\"util\":\"\u76d2\"},{\"id\":\"2dbb11d3cde04c299985ac944d130ba0\",\"productSpecification\":\"150ml\",\"qty\":15,\"money\":520,\"price\":310,\"commandType\":\"\u552f\u4e00\u7801\",\"util\":\"\u76d2\"},{\"id\":\"f8ec261ccdf045e5a2e1f0e5485cda76\",\"productSpecification\":\"40ml\",\"qty\":13,\"money\":530,\"price\":140,\"commandType\":\"\u552f\u4e00\u7801\",\"util\":\"\u76d2\"},{\"id\":\"6c110b57ae56445faa8ce9be501c8997\",\"productSpecification\":\"103ml\",\"qty\":2,\"money\":504,\"price\":150,\"commandType\":\"\u552f\u4e00\u7801\",\"util\":\"\u76d2\"},{\"id\":\"f2ee981aaf934147a4d090a0eed2203f\",\"productSpecification\":\"120ml\",\"qty\":21,\"money\":550,\"price\":160,\"commandType\":\"\u552f\u4e00\u7801\",\"util\":\"\u76d2\"}]";
        List dataAll = JsonUtil.getJsonToList((String)data, ProductEntryMdoel.class);
        List<ProductEntryEntity> productEntryList = this.productEntryService.getProductentryEntityList(id);
        List productList = JsonUtil.getJsonToList(productEntryList, ProductEntryListVO.class);
        for (ProductEntryListVO entry : productList) {
            ArrayList<ProductEntryMdoel> dataList = new ArrayList<ProductEntryMdoel>();
            Random random = new Random();
            int num = random.nextInt(dataAll.size());
            for (int i = 0; i < num; ++i) {
                dataList.add((ProductEntryMdoel)dataAll.get(num));
            }
            entry.setDataList(dataList);
        }
        ListVO vo = new ListVO();
        vo.setList(productList);
        return ActionResult.success((Object)vo);
    }
}

