/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.extend.entity.DocumentEntity;
import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.bringspring.extend.entity.DocumentShareEntity;
import com.bringspring.extend.mapper.DocumentMapper;
import com.bringspring.extend.model.document.DocumentShareForm;
import com.bringspring.extend.model.document.PageDocument;
import com.bringspring.extend.service.DocumentHistoryService;
import com.bringspring.extend.service.DocumentService;
import com.bringspring.extend.service.DocumentShareService;
import com.bringspring.extend.utils.CommonUtil;
import com.bringspring.extend.utils.DictionaryConversion;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
extends ServiceImpl<DocumentMapper, DocumentEntity>
implements DocumentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DocumentShareService documentShareService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DocumentHistoryService documentHistoryService;
    @Autowired
    private DictionaryConversion dictionaryConversion;
    public static String temporaryZip = "temporaryZip" + File.separator;

    @Override
    public List<DocumentEntity> getFolderList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getType, (Object)0)).eq(DocumentEntity::getDeleteMark, (Object)0)).orderByAsc(DocumentEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getAllList(String parentId, String isPublic) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getIsPublic, (Object)isPublic)).eq(DocumentEntity::getDeleteMark, (Object)0)).eq(DocumentEntity::getParentId, (Object)parentId)).orderByAsc(DocumentEntity::getType)).orderByAsc(DocumentEntity::getCreatorTime);
        if ("1".equals(isPublic)) {
            queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getAllList(PageDocument page) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getDeleteMark, (Object)0)).orderByAsc(DocumentEntity::getType)).orderByAsc(DocumentEntity::getCreatorTime)).eq(DocumentEntity::getIsPublic, (Object)page.getIsPublic());
        if (ObjectUtils.isNotEmpty((Object)page.getType())) {
            queryWrapper.lambda().eq(DocumentEntity::getType, (Object)page.getType());
        }
        if (ObjectUtils.isNotEmpty((Object)page.getParentId())) {
            queryWrapper.lambda().eq(DocumentEntity::getParentId, (Object)page.getParentId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getTrashList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getDeleteMark, (Object)1)).orderByAsc(DocumentEntity::getType)).orderByDesc(DocumentEntity::getDeleteTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getShareOutList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getDeleteMark, (Object)0)).gt(DocumentEntity::getIsShare, (Object)0)).orderByAsc(DocumentEntity::getType)).orderByDesc(DocumentEntity::getDeleteTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getShareTomeList() {
        return ((DocumentMapper)this.baseMapper).getShareTomeList(this.userProvider.get().getUserId());
    }

    @Override
    public List<DocumentShareEntity> getShareUserList(String documentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId);
        return this.documentShareService.list((Wrapper)queryWrapper);
    }

    @Override
    public DocumentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getId, (Object)id);
        return (DocumentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(DocumentEntity entity) {
        entity.setDeleteTime(new Date());
        entity.setDeleteUserId(this.userProvider.get().getUserId());
        entity.setDeleteMark(1);
        this.updateById(entity);
    }

    @Override
    public void create(DocumentEntity entity) {
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setDeleteMark(0);
        this.save(entity);
    }

    @Override
    public boolean update(String id, DocumentEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public boolean shareCreate(String documentId, DocumentShareForm documentShareForm) {
        ArrayList<DocumentShareEntity> entitys = new ArrayList<DocumentShareEntity>();
        if (documentShareForm.getShareType().equals("1")) {
            String[] shareUserId;
            for (String item : shareUserId = documentShareForm.getUserId().split(",")) {
                DocumentShareEntity entity = (DocumentShareEntity)JsonUtil.getJsonToBean((Object)documentShareForm, DocumentShareEntity.class);
                String uuId = RandomUtil.uuId();
                entity.setDocumentId(documentId);
                entity.setId(uuId);
                entity.setShareUserId(item);
                entity.setExposeLink(documentShareForm.getExposeLink() + "?id=" + uuId);
                entitys.add(entity);
            }
        } else {
            DocumentShareEntity entity = (DocumentShareEntity)JsonUtil.getJsonToBean((Object)documentShareForm, DocumentShareEntity.class);
            String uuId = RandomUtil.uuId();
            entity.setDocumentId(documentId);
            entity.setId(uuId);
            entity.setExposeLink(documentShareForm.getExposeLink() + "?id=" + uuId);
            entitys.add(entity);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        DocumentEntity entity = (DocumentEntity)this.getOne((Wrapper)queryWrapper.lambda().eq(DocumentEntity::getId, (Object)documentId));
        if (entity != null) {
            entity.setIsShare(entitys.size());
            entity.setShareTime(new Date());
            this.updateById(entity);
            if (documentShareForm.getShareType().equals("1")) {
                QueryWrapper wrapper = new QueryWrapper();
                ((LambdaQueryWrapper)wrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId)).eq(DocumentShareEntity::getShareType, (Object)"1");
                this.documentShareService.remove((Wrapper)wrapper);
            }
            this.documentShareService.saveBatch(entitys);
            return true;
        }
        return false;
    }

    @Override
    public boolean shareUpdate(String shareId, DocumentShareForm documentShareForm) {
        DocumentShareForm shareEntityById = this.getShareEntityById(shareId);
        if (shareEntityById != null) {
            if (documentShareForm.getShareType().equals("1")) {
                String[] shareUserId = documentShareForm.getUserId().split(",");
                ArrayList<DocumentShareEntity> entitys = new ArrayList<DocumentShareEntity>();
                for (String s : shareUserId) {
                    DocumentShareEntity documentShareEntity = (DocumentShareEntity)JsonUtil.getJsonToBean((Object)documentShareForm, DocumentShareEntity.class);
                    documentShareEntity.setShareUserId(s);
                    String uuId = RandomUtil.uuId();
                    documentShareEntity.setId(uuId);
                    String str = org.apache.commons.lang3.StringUtils.substringBefore((String)documentShareEntity.getExposeLink(), (String)"id");
                    documentShareEntity.setExposeLink(str + "id=" + uuId);
                    entitys.add(documentShareEntity);
                }
                QueryWrapper wrapper = new QueryWrapper();
                ((LambdaQueryWrapper)wrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentShareForm.getDocumentId())).eq(DocumentShareEntity::getShareType, (Object)"1");
                this.documentShareService.remove((Wrapper)wrapper);
                this.documentShareService.saveBatch(entitys);
            } else {
                DocumentShareEntity documentShareEntity = (DocumentShareEntity)JsonUtil.getJsonToBean((Object)documentShareForm, DocumentShareEntity.class);
                if ("2".equals(documentShareForm.getPassword())) {
                    documentShareEntity.setPassword(CommonUtil.RandomGenerator());
                }
                this.documentShareService.updateById(documentShareEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    public DocumentShareForm getShareEntityById(String shareId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(DocumentShareEntity::getId, (Object)shareId);
        DocumentShareEntity one = (DocumentShareEntity)this.documentShareService.getOne((Wrapper)wrapper);
        DocumentShareForm documentShareForm = (DocumentShareForm)JsonUtil.getJsonToBean((Object)one, DocumentShareForm.class);
        if (one.getShareType().equals("1")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)one.getDocumentId())).eq(DocumentShareEntity::getShareType, (Object)"1");
            List list = this.documentShareService.list((Wrapper)queryWrapper);
            List collect = list.stream().map(DocumentShareEntity::getShareUserId).collect(Collectors.toList());
            ArrayList<String> userNameList = new ArrayList<String>();
            for (String s : collect) {
                userNameList.add(this.dictionaryConversion.userSelectValues(s));
            }
            documentShareForm.setCreatorUserName(this.dictionaryConversion.userSelectValues(documentShareForm.getCreatorUserId()));
            documentShareForm.setShareUserName(String.join((CharSequence)",", userNameList));
        }
        return documentShareForm;
    }

    @Override
    @DSTransactional
    public boolean shareCancel(String documentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getId, (Object)documentId);
        DocumentEntity entity = (DocumentEntity)this.getOne((Wrapper)queryWrapper);
        if (entity != null) {
            entity.setIsShare(0);
            entity.setShareTime(new Date());
            this.updateById(entity);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId);
            this.documentShareService.remove((Wrapper)wrapper);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleDelShareLink(String id) {
        DocumentShareForm shareEntityById = this.getShareEntityById(id);
        if (shareEntityById != null) {
            DocumentEntity entity;
            List list;
            QueryWrapper queryWrapper;
            if (shareEntityById.getShareType().equals("1")) {
                queryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)shareEntityById.getDocumentId())).eq(DocumentShareEntity::getShareType, (Object)"1");
                list = this.documentShareService.list((Wrapper)queryWrapper);
                this.documentShareService.removeBatchByIds(list);
            } else {
                this.documentShareService.removeById((Serializable)((Object)id));
            }
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)shareEntityById.getDocumentId());
            list = this.documentShareService.list((Wrapper)queryWrapper);
            if (list.isEmpty() && (entity = this.getInfo(shareEntityById.getDocumentId())) != null) {
                entity.setIsShare(0);
                entity.setShareTime(new Date());
                this.updateById(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    @DSTransactional
    public void trashDelete(String folderId) {
        DocumentEntity entity = this.getInfo(folderId);
        if (entity != null) {
            this.removeById((Serializable)((Object)folderId));
            FileUtil.deleteFile((String)(this.configValueUtil.getDocumentFilePath() + entity.getFilePath()));
            List<DocumentHistoryEntity> listByOriginalFileId = this.documentHistoryService.getListByOriginalFileId(entity.getId());
            if (!listByOriginalFileId.isEmpty()) {
                this.documentHistoryService.removeBatchByIds(listByOriginalFileId);
            }
        }
    }

    @Override
    public boolean trashRecovery(String id) {
        DocumentEntity info = this.getInfo(id);
        if (info != null) {
            info.setEnabledMark(0);
            info.setDeleteMark(0);
            this.updateById(info);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(String id, String toId) {
        DocumentEntity entity = this.getInfo(id);
        if (entity != null) {
            entity.setParentId(toId);
            this.updateById(entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistByFullName(DocumentEntity entity) {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getFullName, (Object)entity.getFullName())).eq(DocumentEntity::getDeleteMark, (Object)0)).eq(DocumentEntity::getCreatorUserId, (Object)userId)).eq(DocumentEntity::getFilePath, (Object)entity.getFilePath());
        if (!StringUtils.isEmpty((String)entity.getId())) {
            queryWrapper.lambda().ne(DocumentEntity::getId, (Object)entity.getId());
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public List<DocumentEntity> getListByShareUserId() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentShareEntity::getShareUserId, (Object)userInfo.getUserId());
        List list = this.documentShareService.list((Wrapper)queryWrapper);
        ArrayList<DocumentEntity> documentEntities = new ArrayList<DocumentEntity>();
        if (!list.isEmpty()) {
            for (DocumentShareEntity documentShareEntity : list) {
                DocumentEntity info = this.getInfo(documentShareEntity.getDocumentId());
                if (!ObjectUtils.isNotEmpty((Object)info)) continue;
                documentEntities.add(info);
            }
        }
        return documentEntities;
    }

    @Override
    public DownloadVO getAllDocumentByParentId(String id) {
        ArrayList<DocumentEntity> list = new ArrayList<DocumentEntity>();
        DocumentEntity info = this.getInfo(id);
        UserInfo userInfo = this.userProvider.get();
        this.getAllChildrenDoc(list, id);
        String fromPath = this.configValueUtil.getDocumentFilePath();
        String toPath = this.configValueUtil.getDocumentFilePath() + temporaryZip;
        for (DocumentEntity documentEntity : list) {
            boolean b = FileUtil.copyFile((String)(fromPath + documentEntity.getFilePath()), (String)(toPath + documentEntity.getFilePath()).substring(0, (toPath + documentEntity.getFilePath()).lastIndexOf(File.separator) + 1), (String)documentEntity.getFullName());
            if (b) continue;
            return new DownloadVO();
        }
        String zipName = info.getFullName();
        String outPath = toPath + info.getFilePath();
        String zipPath = toPath + zipName + ".zip";
        if (new File(zipPath).exists()) {
            new File(zipPath).delete();
        }
        FileUtil.toZip((String)zipPath, (boolean)true, (String[])new String[]{outPath + File.separator});
        String fileName = userInfo.getId() + "#" + zipName + ".zip#documentZip#";
        DownloadVO vo = DownloadVO.builder().name(zipName + ".zip").url(UploaderUtil.uploaderFile((String)fileName)).build();
        return vo;
    }

    @Override
    public String getAbsoluteRouteById(String id) {
        UserInfo userInfo = this.userProvider.get();
        Object path = this.configValueUtil.getDocumentFilePath();
        ArrayList<String> pathList = new ArrayList<String>();
        this.getParentPath(pathList, id);
        Collections.reverse(pathList);
        String collect = pathList.stream().collect(Collectors.joining(File.separator));
        path = (String)path + userInfo.getUserId() + File.separator + DateUtil.getNowYear() + File.separator + collect + File.separator;
        return path;
    }

    @Override
    public void clearDoc() {
        String path = this.configValueUtil.getDocumentFilePath() + "temporaryZip";
        DocumentServiceImpl.deleteFileByIO(path);
    }

    public static void deleteFileByIO(String filePath) {
        File file = new File(filePath);
        File[] list = file.listFiles();
        if (list != null) {
            for (File temp : list) {
                DocumentServiceImpl.deleteFileByIO(temp.getAbsolutePath());
            }
        }
        file.delete();
    }

    public void getParentPath(List<String> pathList, String id) {
        DocumentEntity info = this.getInfo(id);
        if (info != null) {
            pathList.add(info.getFullName());
            if (!"0".equals(info.getParentId())) {
                this.getParentPath(pathList, info.getParentId());
            }
        }
    }

    public void getAllChildrenDoc(List<DocumentEntity> childrenList, String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getParentId, (Object)parentId);
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            for (DocumentEntity documentEntity : list) {
                if (documentEntity.getType() == 0) {
                    this.getAllChildrenDoc(childrenList, documentEntity.getId());
                    continue;
                }
                childrenList.add(documentEntity);
            }
        }
    }

    public List<File> getAllDocByAbsoluteRoute(String id) {
        DocumentEntity info = this.getInfo(id);
        String basePath = this.configValueUtil.getDocumentFilePath() + info.getFilePath();
        String path = this.configValueUtil.getDocumentFilePath() + temporaryZip + this.userProvider.get().getUserId() + File.separator + info.getFullName() + File.separator;
        FileUtil.copy((String)basePath, (String)path);
        File dir = new File(path);
        ArrayList<File> allFileList = new ArrayList<File>();
        if (!dir.exists()) {
            System.out.println("\u76ee\u5f55\u4e0d\u5b58\u5728");
            return allFileList;
        }
        DocumentServiceImpl.getAllFile(dir, allFileList);
        return allFileList;
    }

    public static void getAllFile(File fileInput, List<File> allFileList) {
        File[] fileList = fileInput.listFiles();
        assert (fileList != null);
        for (File file : fileList) {
            if (file.isDirectory()) {
                DocumentServiceImpl.getAllFile(file, allFileList);
                continue;
            }
            allFileList.add(file);
        }
    }
}

