package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 产品商品
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021-07-10 15:57:50
 */
@Data
@TableName("ext_productgoods")
public class ProductgoodsEntity {
    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 分类主键
     */
    @TableField("CLASSIFYID")
    private String classifyId;

    /**
     * 产品编号
     */
    @TableField("CODE")
    private String code;

    /**
     * 产品名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 订货类型
     */
    @TableField("TYPE")
    private String type;

    /** 产品规格 */
    @TableField("PRODUCTSPECIFICATION")
    private String productSpecification;

    /** 单价 */
    @TableField("MONEY")
    private String money;

    /**
     * 库存数
     */
    @TableField("QTY")
    private Integer qty;

    /** 金额 */
    @TableField("AMOUNT")
    private String amount;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
