package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 表格示例数据
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_tableexample")
public class TableExampleEntity {
    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 交互日期
     */
    @TableField("INTERACTIONDATE")
    private Date interactionDate;

    /**
     * 项目编码
     */
    @TableField("PROJECTCODE")
    private String projectCode;

    /**
     * 项目名称
     */
    @TableField("PROJECTNAME")
    private String projectName;

    /**
     * 负责人
     */
    @TableField("PRINCIPAL")
    private String principal;

    /**
     * 立顶人
     */
    @TableField("JACKSTANDS")
    private String jackStands;

    /**
     * 项目类型
     */
    @TableField("PROJECTTYPE")
    private String projectType;

    /**
     * 项目阶段
     */
    @TableField("PROJECTPHASE")
    private String projectPhase;

    /**
     * 客户名称
     */
    @TableField("CUSTOMERNAME")
    private String customerName;

    /**
     * 费用金额
     */
    @TableField("COSTAMOUNT")
    private BigDecimal costAmount;

    /**
     * 已用金额
     */
    @TableField("TUNESAMOUNT")
    private BigDecimal tunesAmount;

    /**
     * 预计收入
     */
    @TableField("PROJECTEDINCOME")
    private BigDecimal projectedIncome;

    /**
     * 登记人
     */
    @TableField("REGISTRANT")
    private String registrant;

    /**
     * 登记时间
     */
    @TableField("REGISTERDATE")
    private Date registerDate;

    /**
     * 备注
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 标记
     */
    @TableField("SIGN")
    private String sign;

    /**
     * 批注列表Json
     */
    @TableField("POSTILJSON")
    private String postilJson;

    /**
     * 批注总数
     */
    @TableField("POSTILCOUNT")
    private Integer postilCount;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 编辑时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 编辑用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;
}
