/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.bringspring.extend.model.documenthistory.DocumentHistoryCrForm;
import com.bringspring.extend.model.documenthistory.DocumentHistoryInfoVO;
import com.bringspring.extend.model.documenthistory.DocumentHistoryListVO;
import com.bringspring.extend.model.documenthistory.DocumentHistoryPagination;
import com.bringspring.extend.model.documenthistory.DocumentHistoryUpForm;
import com.bringspring.extend.service.DocumentHistoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u77e5\u8bc6\u6587\u6863", description="\u77e5\u8bc6\u6587\u6863\u5386\u53f2\u8bb0\u5f55\u7ba1\u7406")
@RequestMapping(value={"/api/document/ExtDocumentHistory"})
public class ExtDocumentHistoryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtDocumentHistoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DocumentHistoryService documentHistoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DocumentHistoryPagination documentHistoryPagination) throws IOException {
        List<DocumentHistoryEntity> list = this.documentHistoryService.getList(documentHistoryPagination);
        for (DocumentHistoryEntity documentHistoryEntity : list) {
            documentHistoryEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(documentHistoryEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DocumentHistoryListVO.class);
        for (DocumentHistoryListVO documentHistoryListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)documentHistoryPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DocumentHistoryCrForm documentHistoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        documentHistoryCrForm.setCreatorUserId(userInfo.getUserId());
        documentHistoryCrForm.setCreatorTime(DateUtil.getNow());
        DocumentHistoryEntity entity = (DocumentHistoryEntity)JsonUtil.getJsonToBean((Object)documentHistoryCrForm, DocumentHistoryEntity.class);
        entity.setId(mainId);
        this.documentHistoryService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DocumentHistoryInfoVO> info(@PathVariable(value="id") String id) {
        DocumentHistoryEntity entity = this.documentHistoryService.getInfo(id);
        DocumentHistoryInfoVO vo = (DocumentHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, DocumentHistoryInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DocumentHistoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DocumentHistoryEntity entity = this.documentHistoryService.getInfo(id);
        DocumentHistoryInfoVO vo = (DocumentHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, DocumentHistoryInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DocumentHistoryUpForm documentHistoryUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DocumentHistoryEntity entity = this.documentHistoryService.getInfo(id);
        if (entity != null) {
            DocumentHistoryEntity subentity = (DocumentHistoryEntity)JsonUtil.getJsonToBean((Object)documentHistoryUpForm, DocumentHistoryEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.documentHistoryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DocumentHistoryEntity entity = this.documentHistoryService.getInfo(id);
        if (entity != null) {
            this.documentHistoryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

