/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.ProductgoodsEntity;
import com.bringspring.extend.model.productgoods.ProductgoodsCrForm;
import com.bringspring.extend.model.productgoods.ProductgoodsInfoVO;
import com.bringspring.extend.model.productgoods.ProductgoodsListVO;
import com.bringspring.extend.model.productgoods.ProductgoodsPagination;
import com.bringspring.extend.model.productgoods.ProductgoodsUpForm;
import com.bringspring.extend.service.ProductgoodsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u4ea7\u54c1\u5546\u54c1", description="\u4ea7\u54c1\u5546\u54c1\u4fe1\u606f\u7ba1\u7406")
@RequestMapping(value={"/api/extend/saleOrder/Goods"})
public class ProductgoodsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProductgoodsController.class);
    @Autowired
    private ProductgoodsService productgoodsService;

    @GetMapping(value={"/getGoodList"})
    @Operation(summary="\u5217\u8868")
    public ActionResult list(String type) {
        List<ProductgoodsEntity> list = this.productgoodsService.getGoodList(type);
        List listVO = JsonUtil.getJsonToList(list, ProductgoodsListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @GetMapping
    @Operation(summary="\u5217\u8868")
    public ActionResult list(ProductgoodsPagination goodsPagination) {
        List<ProductgoodsEntity> list = this.productgoodsService.getList(goodsPagination);
        List listVO = JsonUtil.getJsonToList(list, ProductgoodsListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)goodsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Operation(summary="\u521b\u5efa")
    public ActionResult create(@RequestBody @Valid ProductgoodsCrForm goodsCrForm) {
        ProductgoodsEntity entity = (ProductgoodsEntity)JsonUtil.getJsonToBean((Object)goodsCrForm, ProductgoodsEntity.class);
        this.productgoodsService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ProductgoodsInfoVO> info(@PathVariable(value="id") String id) {
        ProductgoodsEntity entity = this.productgoodsService.getInfo(id);
        ProductgoodsInfoVO vo = (ProductgoodsInfoVO)JsonUtil.getJsonToBean((Object)entity, ProductgoodsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="\u66f4\u65b0")
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ProductgoodsUpForm goodsCrFormUpForm) {
        ProductgoodsEntity entity = (ProductgoodsEntity)JsonUtil.getJsonToBean((Object)goodsCrFormUpForm, ProductgoodsEntity.class);
        boolean ok = this.productgoodsService.update(id, entity);
        if (ok) {
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u5220\u9664")
    public ActionResult delete(@PathVariable(value="id") String id) {
        ProductgoodsEntity entity = this.productgoodsService.getInfo(id);
        if (entity != null) {
            this.productgoodsService.delete(entity);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @GetMapping(value={"/Selector"})
    @Operation(summary="\u4e0b\u62c9")
    public ActionResult listSelect(ProductgoodsPagination goodsPagination) {
        goodsPagination.setCurrentPage(1L);
        goodsPagination.setPageSize(50L);
        List<ProductgoodsEntity> list = this.productgoodsService.getList(goodsPagination);
        List listVO = JsonUtil.getJsonToList(list, ProductgoodsListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }
}

