/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.extend.entity.ProductEntity;
import com.bringspring.extend.entity.ProductEntryEntity;
import com.bringspring.extend.mapper.ProductMapper;
import com.bringspring.extend.model.product.ProductPagination;
import com.bringspring.extend.service.ProductEntryService;
import com.bringspring.extend.service.ProductService;
import com.bringspring.system.base.service.BillRuleService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductMapper, ProductEntity>
implements ProductService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private ProductEntryService productEntryService;

    @Override
    public List<ProductEntity> getList(ProductPagination productPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)productPagination.getCode())) {
            queryWrapper.lambda().and(t -> t.like(ProductEntity::getCode, (Object)productPagination.getCode()));
        }
        if (StringUtils.isNotEmpty((String)productPagination.getCustomerName())) {
            queryWrapper.lambda().and(t -> t.like(ProductEntity::getCustomerName, (Object)productPagination.getCustomerName()));
        }
        if (StringUtils.isNotEmpty((String)productPagination.getContactTel())) {
            queryWrapper.lambda().and(t -> t.like(ProductEntity::getContactTel, (Object)productPagination.getContactTel()));
        }
        queryWrapper.lambda().orderByDesc(ProductEntity::getCreatorTime);
        Page page = new Page(productPagination.getCurrentPage(), productPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return productPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public ProductEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProductEntity::getId, (Object)id);
        return (ProductEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(ProductEntity entity, List<ProductEntryEntity> productEntryList) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String code = this.billRuleService.getBillNumber("OrderNumber", false);
        entity.setCode(code);
        entity.setType("\u5e02\u573a\u6d3b\u52a8");
        entity.setSalesmanId(userInfo.getUserId());
        entity.setSalesmanName(userInfo.getRealName());
        entity.setSalesmanDate(new Date());
        entity.setAuditState(1);
        entity.setGoodsState(1);
        entity.setCloseState(1);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setId(RandomUtil.uuId());
        this.save(entity);
        for (ProductEntryEntity product : productEntryList) {
            product.setId(RandomUtil.uuId());
            product.setActivity("\u5e02\u573a\u90e8\u5168\u56fd\u9999\u98ce\u5065\u5eb7\u5962\u62a4");
            product.setType("\u5e02\u573a\u6d3b\u52a8");
            product.setUtil("\u652f");
            product.setCommandType("\u552f\u4e00\u7801");
            product.setProductId(entity.getId());
            this.productEntryService.save(product);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, ProductEntity entity, List<ProductEntryEntity> productEntryList) {
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        entity.setLastModifyTime(new Date());
        QueryWrapper entryWrapper = new QueryWrapper();
        entryWrapper.lambda().eq(ProductEntryEntity::getProductId, (Object)entity.getId());
        this.productEntryService.remove((Wrapper)entryWrapper);
        for (ProductEntryEntity product : productEntryList) {
            product.setId(RandomUtil.uuId());
            product.setProductId(entity.getId());
            this.productEntryService.save(product);
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(ProductEntity entity) {
        if (entity != null) {
            QueryWrapper entryWrapper = new QueryWrapper();
            entryWrapper.lambda().eq(ProductEntryEntity::getProductId, (Object)entity.getId());
            this.productEntryService.remove((Wrapper)entryWrapper);
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

