package com.bringspring.extend.model.document;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:58
 */
@Data
public class DocumentCrForm {
    @NotBlank(message = "必填")
    @Schema(description = "文件夹名称")
    private String fullName;
    @NotNull(message = "必填")
    @Schema(description = "文档分类")
    private Integer type;
    @NotBlank(message = "必填")
    @Schema(description = "文档父级")
    private String parentId;
    private String isPublic;
    //摘要
    @Schema(description = "摘要")
    private String description;
    //标签
    @Schema(description = "文件标签")
    private String fileLable;
    //路径
    @Schema(description = "存储路径")
    private String filePath;
    //文档类型
    @Schema(description = "文档类型")
    private String fileType;
    //关联产品
    @Schema(description = "关联产品")
    private String associationProduct;
    /** 公开类型 */
    @Schema(description = "公开类型")
    private String disclosureType;


}
