package com.bringspring.extend.model.document;

import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:58
 */
@Data
public class DocumentListVO {
    @Schema(description = "主键id")
    private String id;
    @Schema(description = "文件夹名称")
    private String fullName;
    @Schema(description = "文档分类(0-文件夹，1-文件)")
    private Integer type;
    @Schema(description = "创建日期")
    private Long creatorTime;
    @Schema(description = "是否分享")
    private Integer isShare;
    @Schema(description = "大小")
    private String fileSize;
    @Schema(description = "父级Id")
    private String parentId;
    @Schema(description = "后缀名")
    private String fileExtension;
    @JsonProperty("fileVersion")
    private String fileVersion;
    @JsonProperty("documentHistory")
    private List<DocumentHistoryEntity> documentHistory;

    private String isPublic;

    //摘要
    @Schema(description = "摘要")
    private String description;
    //标签
    @Schema(description = "文件标签")
    private String fileLable;
    //路径
    @Schema(description = "路径")
    private String filePath;
    //公司名称
    @Schema(description = "公司名称")
    private String companyName;
    //公司ID
    @Schema(description = "公司ID")
    private String companyId;


}
