package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售订单
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021-07-10 10:40:59
 */
@Data
@TableName("ext_product")
public class ProductEntity {
    /**
     * 名称
     */
    @TableId("ID")
    private String id;

    /**
     * 订单编号
     */
    @TableField("CODE")
    private String code;

    /**
     * 客户类别
     */
    @TableField("TYPE")
    private String type;

    /**
     * 客户id
     */
    @TableField("CUSTOMERID")
    private String customerId;

    /**
     * 客户名称
     */
    @TableField("CustomerName")
    private String customerName;

    /**
     * 制单人
     */
    @TableField("SALESMANID")
    private String salesmanId;

    /**
     * 制单人
     */
    @TableField("SALESMANNAME")
    private String salesmanName;

    /**
     * 制单日期
     */
    @TableField("SALESMANDATE")
    private Date salesmanDate;

    /**
     * 审核人
     */
    @TableField("AUDITNAME")
    private String auditName;

    /**
     * 审核日期
     */
    @TableField("AUDITDATE")
    private Date auditDate;

    /**
     * 审核状态
     */
    @TableField("AUDITSTATE")
    private Integer auditState;

    /**
     * 发货仓库
     */
    @TableField("GOODSWAREHOUSE")
    private String goodsWarehouse;

    /**
     * 发货日期
     */
    @TableField("GOODSDATE")
    private Date goodsDate;

    /**
     * 发货通知人
     */
    @TableField("CONSIGNOR")
    private String consignor;

    /**
     * 发货状态
     */
    @TableField("GOODSSTATE")
    private Integer goodsState;

    /**
     * 关闭状态
     */
    @TableField("CLOSESTATE")
    private Integer closeState;

    /**
     * 关闭日期
     */
    @TableField("CLOSEDATE")
    private Date closeDate;

    /**
     * 收款方式
     */
    @TableField("GATHERINGTYPE")
    private String gatheringType;

    /**
     * 业务员
     */
    @TableField("BUSINESS")
    private String business;

    /**
     * 送货地址
     */
    @TableField("ADDRESS")
    private String address;

    /**
     * 联系方式
     */
    @TableField("CONTACTTEL")
    private String contactTel;

    /**
     * 联系人
     */
    @TableField("CONTACTNAME")
    private String contactName;

    /**
     * 收货消息
     */
    @TableField("HARVESTMSG")
    private Integer harvestMsg;

    /**
     * 收货仓库
     */
    @TableField("HARVESTWAREHOUSE")
    private String harvestWarehouse;

    /**
     * 代发客户
     */
    @TableField("ISSUINGNAME")
    private String issuingName;

    /**
     * 让利金额
     */
    @TableField("PARTPRICE")
    private BigDecimal partPrice;

    /**
     * 优惠金额
     */
    @TableField("REDUCEDPRICE")
    private BigDecimal reducedPrice;

    /**
     * 折后金额
     */
    @TableField("DISCOUNTPRICE")
    private BigDecimal discountPrice;

    /**
     * 备注
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
