package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 产品明细
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021-07-10 10:40:59
 */
@Data
@TableName("ext_productentry")
public class ProductEntryEntity {

    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 订单主键
     */
    @TableField("PRODUCTID")
    private String productId;

    /**
     * 产品编码
     */
    @TableField("PRODUCTCODE")
    private String productCode;

    /**
     * 产品名称
     */
    @TableField("PRODUCTNAME")
    private String productName;

    /**
     * 产品规格
     */
    @TableField("PRODUCTSPECIFICATION")
    private String productSpecification;

    /**
     * 数量
     */
    @TableField("QTY")
    private Integer qty;

    /**
     * 订货类型
     */
    @TableField("TYPE")
    private String type;

    /**
     * 单价
     */
    @TableField("MONEY")
    private BigDecimal money;

    /**
     * 折后单价
     */
    @TableField("PRICE")
    private BigDecimal price;

    /**
     * 单位
     */
    @TableField("UTIL")
    private String util;

    /**
     * 控制方式
     */
    @TableField("COMMANDTYPE")
    private String commandType;

    /**
     * 金额
     */
    @TableField("AMOUNT")
    private BigDecimal amount;

    /**
     * 活动
     */
    @TableField("ACTIVITY")
    private String activity;

    /**
     * 备注
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
