package com.bringspring.extend.model.schedule;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

@Data
public class SchedulePcListVO {
    @Schema(description = "日程主键")
    private String id;
    @Schema(description = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date startTime;
    @Schema(description = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endTime;
    @Schema(description = "颜色")
    private String colour;
    @Schema(description = "日程内容")
    private String content;

    @JsonProperty("creatorTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date creatorTime;

    @JsonProperty("title")
    private String title;

    //    状态
    @JsonProperty("state")
    private String state;

    private String time;
}
