package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FileModel;
import com.bringspring.common.util.*;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.extend.entity.OrderEntity;
import com.bringspring.extend.entity.OrderEntryEntity;
import com.bringspring.extend.entity.OrderReceivableEntity;
import com.bringspring.extend.mapper.OrderMapper;
import com.bringspring.extend.model.order.*;
import com.bringspring.extend.service.OrderEntryService;
import com.bringspring.extend.service.OrderReceivableService;
import com.bringspring.extend.service.OrderService;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.util.FileManageUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.enums.FlowHandleEventEnum;
import com.bringspring.workflow.engine.enums.FlowModuleEnum;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:19
 */
@Service
@DSTransactional
public class OrderServiceImpl extends ServiceImpl<OrderMapper, OrderEntity> implements OrderService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrderReceivableService orderReceivableService;
    @Autowired
    private OrderEntryService orderEntryService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private FileManageUtil fileManageUtil;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;

    /**
     * 前单
     **/
    private static String PREV = "prev";
    /**
     * 后单
     **/
    private static String NEXT = "next";

    @Override
    public List<OrderEntity> getList(PaginationOrder paginationOrder) {
        UserInfo userInfo = userProvider.get();
        QueryWrapper<OrderEntity> queryWrapper = new QueryWrapper<>();
        //关键字（订单编码、客户名称、业务人员）
        String keyWord = paginationOrder.getKeyword() != null ? paginationOrder.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty(keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(
                    t -> t.like(OrderEntity::getOrderCode, word)
                            .or().like(OrderEntity::getCustomerName, word)
                            .or().like(OrderEntity::getSalesmanName, word)
            );
        }
        //起始日期-结束日期
        String startTime = paginationOrder.getStartTime() != null ? paginationOrder.getStartTime() : null;
        String endTime = paginationOrder.getEndTime() != null ? paginationOrder.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty(startTime) && !org.apache.commons.lang3.StringUtils.isEmpty(endTime)) {
            Date startTimes = DateUtil.stringToDate(DateUtil.daFormatYmd(Long.parseLong(startTime)) + " 00:00:00");
            Date endTimes = DateUtil.stringToDate(DateUtil.daFormatYmd(Long.parseLong(endTime)) + " 23:59:59");
            queryWrapper.lambda().ge(OrderEntity::getOrderDate, startTimes).le(OrderEntity::getOrderDate, endTimes);
        }
        //订单状态
        String mark = paginationOrder.getEnabledMark() != null ? paginationOrder.getEnabledMark() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty(mark)) {
            queryWrapper.lambda().eq(OrderEntity::getEnabledMark, mark);
        }
        //排序
        if (org.apache.commons.lang3.StringUtils.isEmpty(paginationOrder.getSidx())) {
            queryWrapper.lambda().orderByDesc(OrderEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(paginationOrder.getSort().toLowerCase()) ? queryWrapper.orderByAsc(paginationOrder.getSidx()) : queryWrapper.orderByDesc(paginationOrder.getSidx());
        }
        //数据权限过滤
        if (!userInfo.getIsAdministrator()) {
            Object obj = queryWrapper;
            queryWrapper = (QueryWrapper<OrderEntity>) authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, "F4FCA43A-B563-4149-AB16-486589CFC154","ext_order"));
        }
        Page<OrderEntity> page = new Page<>(paginationOrder.getCurrentPage(), paginationOrder.getPageSize());
        IPage<OrderEntity> orderEntityPage = this.page(page, queryWrapper);
        List<OrderEntity> data = orderEntityPage.getRecords();
        List<String> id = data.stream().map(t -> t.getId()).collect(Collectors.toList());
        if (data.size() > 0) {
            List<FlowTaskEntity> orderStaList = flowTaskService.getOrderStaList(id);
            for (OrderEntity entity : data) {
                FlowTaskEntity taskEntity = orderStaList.stream().filter(t -> t.getId().equals(entity.getId())).findFirst().orElse(null);
                if (taskEntity != null) {
                    entity.setCurrentState(taskEntity.getStatus());
                }
            }
        }
        return paginationOrder.setData(data, page.getTotal());
    }

    @Override
    public List<OrderEntryEntity> getOrderEntryList(String id) {
        QueryWrapper<OrderEntryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(OrderEntryEntity::getOrderId, id).orderByDesc(OrderEntryEntity::getSortCode);
        return orderEntryService.list(queryWrapper);
    }

    @Override
    public List<OrderReceivableEntity> getOrderReceivableList(String id) {
        QueryWrapper<OrderReceivableEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(OrderReceivableEntity::getOrderId, id).orderByDesc(OrderReceivableEntity::getSortCode);
        return orderReceivableService.list(queryWrapper);
    }

    @Override
    public OrderEntity getPrevOrNextInfo(String id, String method) {
        QueryWrapper<OrderEntity> result = new QueryWrapper<>();
        OrderEntity orderEntity = getInfo(id);
        String orderBy = "desc";
        if (PREV.equals(method)) {
            result.lambda().gt(OrderEntity::getCreatorTime, orderEntity.getCreatorTime());
            orderBy = "";
        } else if (NEXT.equals(method)) {
            result.lambda().lt(OrderEntity::getCreatorTime, orderEntity.getCreatorTime());
        }
        result.lambda().notIn(OrderEntity::getId, orderEntity.getId());
        if (StringUtils.isNotEmpty(orderBy)) {
            result.lambda().orderByDesc(OrderEntity::getCreatorTime);
        }
        List<OrderEntity> data = this.list(result);
        if (data.size() > 0) {
            return data.get(0);
        }
        return null;
    }

    @Override
    public OrderInfoVO getInfoVo(String id, String method) throws DataException {
        OrderInfoVO infoModel = null;
        OrderEntity orderEntity = this.getPrevOrNextInfo(id, method);
        if (orderEntity != null) {
            List<OrderEntryEntity> orderEntryList = this.getOrderEntryList(orderEntity.getId());
            List<OrderReceivableEntity> orderReceivableList = this.getOrderReceivableList(orderEntity.getId());
            infoModel = JsonUtilEx.getJsonToBeanEx(orderEntity, OrderInfoVO.class);
            UserEntity createUser = null;
            if (StringUtils.isNotEmpty(infoModel.getCreatorUserId())) {
                createUser = userService.getInfo(infoModel.getCreatorUserId());
            }
            infoModel.setCreatorUserId(createUser != null ? createUser.getRealName(): "");
            UserEntity lastUser = null;
            if (StringUtils.isNotEmpty(infoModel.getLastModifyUserId())) {
                lastUser = userService.getInfo(infoModel.getLastModifyUserId());
            }
            infoModel.setLastModifyUserId(lastUser != null ? lastUser.getRealName(): "");
            List<OrderInfoOrderEntryModel> orderEntryModels = JsonUtil.getJsonToList(orderEntryList, OrderInfoOrderEntryModel.class);
            infoModel.setGoodsList(orderEntryModels);
            List<OrderInfoOrderReceivableModel> orderReceivableModels = JsonUtil.getJsonToList(orderReceivableList, OrderInfoOrderReceivableModel.class);
            infoModel.setCollectionPlanList(orderReceivableModels);
        }
        return infoModel;
    }

    @Override
    public OrderEntity getInfo(String id) {
        QueryWrapper<OrderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(OrderEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void delete(OrderEntity entity) {
        QueryWrapper<OrderEntity> orderWrapper = new QueryWrapper<>();
        orderWrapper.lambda().eq(OrderEntity::getId, entity.getId());
        this.remove(orderWrapper);
        QueryWrapper<OrderEntryEntity> entryWrapper = new QueryWrapper<>();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, entity.getId());
        orderEntryService.remove(entryWrapper);
        QueryWrapper<OrderReceivableEntity> receivableWrapper = new QueryWrapper<>();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, entity.getId());
        orderReceivableService.remove(receivableWrapper);
        fileManageUtil.deleteFile(JsonUtil.getJsonToList(entity.getFileJson(), FileModel.class));
    }

    @Override
    public void create(OrderEntity entity, List<OrderEntryEntity> orderEntryList, List<OrderReceivableEntity> orderReceivableList, OrderForm orderForm) throws WorkFlowException {
        try {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(userProvider.get().getUserId());
            entity.setEnabledMark(1);
            for (int i = 0; i < orderEntryList.size(); i++) {
                orderEntryList.get(i).setId(RandomUtil.uuId());
                orderEntryList.get(i).setOrderId(entity.getId());
                orderEntryList.get(i).setSortCode(Long.parseLong(i + ""));
                orderEntryService.save(orderEntryList.get(i));
            }
            for (int i = 0; i < orderReceivableList.size(); i++) {
                orderReceivableList.get(i).setId(RandomUtil.uuId());
                orderReceivableList.get(i).setOrderId(entity.getId());
                orderReceivableList.get(i).setSortCode(Long.parseLong(i + ""));
                orderReceivableService.save(orderReceivableList.get(i));
            }
            billRuleService.useBillNumber("OrderNumber");
            if (FlowTaskStatusEnum.Handle.getCode().equals(orderForm.getStatus())) {
                String flowModuleMark = FlowModuleEnum.CRM_Order.getMessage();
                FlowEngineEntity flowEngineEntity = flowEngineService.getInfoByEnCode(flowModuleMark);
                entity.setCurrentState(FlowTaskStatusEnum.Handle.getCode());
                entity.setLastModifyTime(new Date());
                entity.setLastModifyUserId(userProvider.get().getUserId());
                flowSubmit(flowEngineEntity, orderForm.getFreeApproverUserId(), entity,orderForm.getCandidateList());
            }
            fileManageUtil.createFile(JsonUtil.getJsonToList(entity.getFileJson(), FileModel.class));
            this.save(entity);
        } catch (WorkFlowException | DataException e) {
            //手动回滚事务
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new WorkFlowException(e.getMessage());
        }
    }

    @Override
    public boolean update(String id, OrderEntity entity, List<OrderEntryEntity> orderEntryList, List<OrderReceivableEntity> orderReceivableList, OrderForm orderForm) throws WorkFlowException, DataException {
        //删除原本的文件
        OrderEntity deEntity = getInfo(id);
        List<FileModel> list1 = JsonUtil.getJsonToList(deEntity.getFileJson(), FileModel.class);
        for (FileModel model : list1) {
            model.setFileType("delete");
        }
        fileManageUtil.updateFile(list1);
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        QueryWrapper<OrderEntryEntity> entryWrapper = new QueryWrapper<>();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, entity.getId());
        orderEntryService.remove(entryWrapper);
        QueryWrapper<OrderReceivableEntity> receivableWrapper = new QueryWrapper<>();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, entity.getId());
        orderReceivableService.remove(receivableWrapper);
        for (int i = 0; i < orderEntryList.size(); i++) {
            orderEntryList.get(i).setId(RandomUtil.uuId());
            orderEntryList.get(i).setOrderId(entity.getId());
            orderEntryList.get(i).setSortCode(Long.parseLong(i + ""));
            orderEntryService.save(orderEntryList.get(i));
        }
        for (int i = 0; i < orderReceivableList.size(); i++) {
            orderReceivableList.get(i).setId(RandomUtil.uuId());
            orderReceivableList.get(i).setOrderId(entity.getId());
            orderReceivableList.get(i).setSortCode(Long.parseLong(i + ""));
            orderReceivableService.save(orderReceivableList.get(i));
        }
        //添加新的文件
        List<FileModel> list2 = JsonUtil.getJsonToList(entity.getFileJson(), FileModel.class);
        for (FileModel model : list2) {
            model.setFileType("add");
        }
        fileManageUtil.updateFile(list2);
        if (FlowTaskStatusEnum.Handle.getCode().equals(orderForm.getStatus())) {
            String flowModuleMark = FlowModuleEnum.CRM_Order.getMessage();
            FlowEngineEntity flowEngineEntity = flowEngineService.getInfoByEnCode(flowModuleMark);
            entity.setCurrentState(FlowTaskStatusEnum.Handle.getCode());
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userProvider.get().getUserId());
            flowSubmit(flowEngineEntity, orderForm.getFreeApproverUserId(), entity,orderForm.getCandidateList());
        }
        boolean flag = this.updateById(entity);
        return flag;
    }

    @Override
    public void flowSubmit(FlowEngineEntity flowEngineEntity, String freeApproverUserId, OrderEntity orderEntity, Map<String, List<String>> candidateList) throws WorkFlowException, DataException {
        UserInfo userInfo = userProvider.get();
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfoSubmit(orderEntity.getId(), FlowTaskEntity::getId);
        String id = null;
        if (flowTaskEntity != null) {
            id = flowTaskEntity.getId();
        }
        FlowUtil.submit(id, flowEngineEntity.getId(),null, orderEntity.getId(), userInfo.getRealName() + "的订单示例", 1, orderEntity.getOrderCode(), orderEntity, freeApproverUserId,candidateList);
    }

    @Override
    public void flowRevoke(FlowTaskEntity flowTaskEntity, FlowHandleModel flowHandleModel) throws WorkFlowException {
        OrderEntity orderEntity = getInfo(flowTaskEntity.getProcessId());
        orderEntity.setCurrentState(FlowTaskStatusEnum.Revoke.getCode());
        orderEntity.setLastModifyTime(new Date());
        this.updateById(orderEntity);
        List<FlowTaskNodeEntity> flowTaskNodeEntityList = flowTaskNodeService.getList(flowTaskEntity.getId());
        Optional<FlowTaskNodeEntity> first = flowTaskNodeEntityList.stream().filter(m -> "2".equals(String.valueOf(m.getSortCode()))).findFirst();
        if(!first.isPresent()){
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity flowTaskNodeEntity = first.get();
        if (flowTaskNodeEntity.getCompletion() > 0) {
            throw new WorkFlowException(MsgCode.WF104.get());
        } else {
            FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
            flowTaskNewService.revoke(flowTaskEntity, flowModel);
        }
    }

    @Override
    public void flowHandleEvent(FlowHandleEventEnum flowHandleEvent, FlowTaskEntity flowTaskEntity) {
        OrderEntity orderEntity = this.getInfo(flowTaskEntity.getProcessId());
        if (orderEntity != null) {
            orderEntity.setCurrentState(flowTaskEntity.getStatus());
            this.updateById(orderEntity);
        }
    }

    @Override
    public void data(String id, String data) {
        OrderForm orderForm = JsonUtil.getJsonToBean(data, OrderForm.class);
        OrderEntity entity = JsonUtil.getJsonToBean(orderForm, OrderEntity.class);
        List<OrderEntryModel> goodsList = orderForm.getGoodsList() != null ? orderForm.getGoodsList() : new ArrayList<>();
        List<OrderEntryEntity> orderEntryList = JsonUtil.getJsonToList(goodsList, OrderEntryEntity.class);
        List<OrderReceivableModel> collectionPlanList = orderForm.getCollectionPlanList() != null ? orderForm.getCollectionPlanList() : new ArrayList<>();
        List<OrderReceivableEntity> orderReceivableList = JsonUtil.getJsonToList(collectionPlanList, OrderReceivableEntity.class);
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        QueryWrapper<OrderEntryEntity> entryWrapper = new QueryWrapper<>();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, entity.getId());
        orderEntryService.remove(entryWrapper);
        QueryWrapper<OrderReceivableEntity> receivableWrapper = new QueryWrapper<>();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, entity.getId());
        orderReceivableService.remove(receivableWrapper);
        for (int i = 0; i < orderEntryList.size(); i++) {
            orderEntryList.get(i).setId(RandomUtil.uuId());
            orderEntryList.get(i).setOrderId(entity.getId());
            orderEntryList.get(i).setSortCode(Long.parseLong(i + ""));
            orderEntryService.save(orderEntryList.get(i));
        }
        for (int i = 0; i < orderReceivableList.size(); i++) {
            orderReceivableList.get(i).setId(RandomUtil.uuId());
            orderReceivableList.get(i).setOrderId(entity.getId());
            orderReceivableList.get(i).setSortCode(Long.parseLong(i + ""));
            orderReceivableService.save(orderReceivableList.get(i));
        }
        this.saveOrUpdate(entity);
    }


}
