package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ProductgoodsEntity;
import com.bringspring.extend.mapper.ProductgoodsMapper;
import com.bringspring.extend.model.productgoods.ProductgoodsPagination;
import com.bringspring.extend.service.ProductgoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 产品商品
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-07-10 15:57:50
 */
@Service

public class ProductgoodsServiceImpl extends ServiceImpl<ProductgoodsMapper, ProductgoodsEntity> implements ProductgoodsService {

    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ProductgoodsEntity> getGoodList(String type) {
        QueryWrapper<ProductgoodsEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(type)) {
            queryWrapper.lambda().eq(ProductgoodsEntity::getType, type);
        }
        return this.list(queryWrapper);
    }

    @Override
    public List<ProductgoodsEntity> getList(ProductgoodsPagination goodsPagination) {
        QueryWrapper<ProductgoodsEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(goodsPagination.getCode())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getCode, goodsPagination.getCode());
        }
        if (StringUtils.isNotEmpty(goodsPagination.getFullName())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getFullName, goodsPagination.getFullName());
        }
        if (StringUtils.isNotEmpty(goodsPagination.getClassifyId())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getClassifyId, goodsPagination.getClassifyId());
        }
        if (StringUtils.isNotEmpty(goodsPagination.getKeyword())) {
            queryWrapper.lambda().and(
                    t -> t.like(ProductgoodsEntity::getFullName, goodsPagination.getKeyword())
                            .or().like(ProductgoodsEntity::getCode, goodsPagination.getKeyword())
                            .or().like(ProductgoodsEntity::getProductSpecification, goodsPagination.getKeyword())
            );
        }
        //排序
        if (StringUtils.isEmpty(goodsPagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(ProductgoodsEntity::getId);
        } else {
            queryWrapper = "asc".equals(goodsPagination.getSort().toLowerCase()) ? queryWrapper.orderByAsc(goodsPagination.getSidx()) : queryWrapper.orderByDesc(goodsPagination.getSidx());
        }
        Page<ProductgoodsEntity> page = new Page<>(goodsPagination.getCurrentPage(), goodsPagination.getPageSize());
        IPage<ProductgoodsEntity> userIPage = this.page(page, queryWrapper);
        return goodsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public ProductgoodsEntity getInfo(String id) {
        QueryWrapper<ProductgoodsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProductgoodsEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(ProductgoodsEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userProvider.get().getUserId());
        entity.setCreatorTime(new Date());
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProductgoodsEntity entity) {
        entity.setId(id);
        entity.setLastModifyUserId(userProvider.get().getUserId());
        entity.setLastModifyTime(new Date());
        return this.updateById(entity);
    }

    @Override
    public void delete(ProductgoodsEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

}