/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.extend.entity.ProductclassifyEntity;
import com.bringspring.extend.model.productclassify.ProductclassifyCrForm;
import com.bringspring.extend.model.productclassify.ProductclassifyInfoVO;
import com.bringspring.extend.model.productclassify.ProductclassifyListVO;
import com.bringspring.extend.model.productclassify.ProductclassifyModel;
import com.bringspring.extend.model.productclassify.ProductclassifyUpForm;
import com.bringspring.extend.service.ProductclassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u5e93"}, value="Classify")
@RequestMapping(value={"/api/extend/saleOrder/Classify"})
public class ProductclassifyController {
    private static final Logger log = LoggerFactory.getLogger(ProductclassifyController.class);
    @Autowired
    private ProductclassifyService productclassifyService;

    @GetMapping
    @ApiOperation(value="\u5217\u8868")
    public ActionResult list() {
        List<ProductclassifyEntity> data = this.productclassifyService.getList();
        List modelList = JsonUtil.getJsonToList(data, ProductclassifyModel.class);
        List sumTrees = TreeDotUtils.convertListToTreeDot((List)modelList);
        List list = JsonUtil.getJsonToList((Object)sumTrees, ProductclassifyListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa")
    public ActionResult create(@RequestBody @Valid ProductclassifyCrForm classifyCrForm) {
        ProductclassifyEntity entity = (ProductclassifyEntity)JsonUtil.getJsonToBean((Object)classifyCrForm, ProductclassifyEntity.class);
        this.productclassifyService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u4fe1\u606f")
    public ActionResult<ProductclassifyInfoVO> info(@PathVariable(value="id") String id) {
        ProductclassifyEntity entity = this.productclassifyService.getInfo(id);
        ProductclassifyInfoVO vo = (ProductclassifyInfoVO)JsonUtil.getJsonToBean((Object)entity, ProductclassifyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u66f4\u65b0")
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ProductclassifyUpForm classifyUpForm) {
        ProductclassifyEntity entity = (ProductclassifyEntity)JsonUtil.getJsonToBean((Object)classifyUpForm, ProductclassifyEntity.class);
        boolean ok = this.productclassifyService.update(id, entity);
        if (ok) {
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664")
    public ActionResult delete(@PathVariable(value="id") String id) {
        ProductclassifyEntity entity = this.productclassifyService.getInfo(id);
        if (entity != null) {
            this.productclassifyService.delete(entity);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

