/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.MailAccount;
import com.bringspring.common.base.MailFile;
import com.bringspring.common.base.MailModel;
import com.bringspring.common.base.PaginationTime;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.extend.entity.EmailSendEntity;
import com.bringspring.extend.mapper.EmailReceiveMapper;
import com.bringspring.extend.service.EmailConfigService;
import com.bringspring.extend.service.EmailReceiveService;
import com.bringspring.extend.service.EmailSendService;
import com.bringspring.system.base.entity.EmailConfigEntity;
import com.bringspring.system.base.entity.EmailReceiveEntity;
import com.bringspring.system.base.util.Pop3Util;
import com.bringspring.system.base.util.SmtpUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailReceiveServiceImpl
extends ServiceImpl<EmailReceiveMapper, EmailReceiveEntity>
implements EmailReceiveService {
    private static final Logger log = LoggerFactory.getLogger(EmailReceiveServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EmailSendService emailSendService;
    @Autowired
    private EmailConfigService emailConfigService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private Pop3Util pop3Util;

    @Override
    public List<EmailReceiveEntity> getReceiveList(PaginationTime paginationTime) {
        String keyWord;
        String endTime;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EmailReceiveEntity::getCreatorUserId, (Object)userId);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((CharSequence)startTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(EmailReceiveEntity::getFdate, (Object)startTimes)).le(EmailReceiveEntity::getFdate, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EmailReceiveEntity::getSender, (Object)word)).or()).like(EmailReceiveEntity::getSubject, (Object)word);
            });
        }
        if (StringUtils.isEmpty((CharSequence)paginationTime.getSidx())) {
            queryWrapper.lambda().orderByDesc(EmailReceiveEntity::getFdate);
        } else {
            queryWrapper = "asc".equals(paginationTime.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)paginationTime.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)paginationTime.getSidx());
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userIpage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userIpage.getRecords(), page.getTotal());
    }

    @Override
    public List<EmailReceiveEntity> getReceiveList() {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EmailReceiveEntity::getCreatorUserId, (Object)userId)).eq(EmailReceiveEntity::getIsRead, (Object)0)).orderByDesc(EmailReceiveEntity::getCreatorTime);
        return ((EmailReceiveMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<EmailReceiveEntity> getDashboardReceiveList() {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EmailReceiveEntity::getCreatorUserId, (Object)userId)).eq(EmailReceiveEntity::getIsRead, (Object)0)).orderByDesc(EmailReceiveEntity::getCreatorTime);
        Page page = new Page(1L, 20L);
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return iPage.getRecords();
    }

    @Override
    public List<EmailReceiveEntity> getStarredList(PaginationTime paginationTime) {
        String keyWord;
        String endTime;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EmailReceiveEntity::getCreatorUserId, (Object)userId)).eq(EmailReceiveEntity::getStarred, (Object)1);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((CharSequence)startTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(EmailReceiveEntity::getCreatorTime, (Object)startTimes)).le(EmailReceiveEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EmailReceiveEntity::getSender, (Object)word)).or()).like(EmailReceiveEntity::getSubject, (Object)word);
            });
        }
        if (StringUtils.isEmpty((CharSequence)paginationTime.getSidx())) {
            queryWrapper.lambda().orderByDesc(EmailReceiveEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(paginationTime.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)paginationTime.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)paginationTime.getSidx());
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userIpage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userIpage.getRecords(), page.getTotal());
    }

    @Override
    public List<EmailSendEntity> getDraftList(PaginationTime paginationTime) {
        String keyWord;
        String endTime;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EmailSendEntity::getCreatorUserId, (Object)userId)).eq(EmailSendEntity::getState, (Object)-1);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getEndTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((CharSequence)startTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(EmailSendEntity::getCreatorTime, (Object)startTimes)).le(EmailSendEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? paginationTime.getKeyword() : null;
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EmailSendEntity::getSender, (Object)word)).or()).like(EmailSendEntity::getSubject, (Object)word);
            });
        }
        if (StringUtils.isEmpty((CharSequence)paginationTime.getSidx())) {
            queryWrapper.lambda().orderByDesc(EmailSendEntity::getCreatorTime);
        } else {
            queryWrapper = "asc".equals(paginationTime.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)paginationTime.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)paginationTime.getSidx());
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userIpage = this.emailSendService.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userIpage.getRecords(), page.getTotal());
    }

    @Override
    public List<EmailSendEntity> getSentList(PaginationTime paginationTime) {
        String sort;
        String keyWord;
        String endTime;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EmailSendEntity::getCreatorUserId, (Object)userId)).ne(EmailSendEntity::getState, (Object)-1);
        String startTime = paginationTime.getStartTime() != null ? paginationTime.getStartTime() : null;
        String string = endTime = paginationTime.getEndTime() != null ? paginationTime.getEndTime() : null;
        if (!StringUtils.isEmpty((CharSequence)startTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(EmailSendEntity::getCreatorTime, (Object)startTimes)).le(EmailSendEntity::getCreatorTime, (Object)endTimes);
        }
        String string2 = keyWord = paginationTime.getKeyword() != null ? String.valueOf(paginationTime.getKeyword()) : null;
        if (!StringUtils.isEmpty((CharSequence)keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EmailSendEntity::getSender, (Object)word)).or()).like(EmailSendEntity::getSubject, (Object)word);
            });
        }
        String string3 = sort = paginationTime.getSort() != null ? paginationTime.getSort() : null;
        if (!StringUtils.isEmpty((CharSequence)sort)) {
            queryWrapper.lambda().orderByDesc(EmailSendEntity::getCreatorTime);
        }
        Page page = new Page(paginationTime.getCurrentPage(), paginationTime.getPageSize());
        IPage userIpage = this.emailSendService.page((IPage)page, (Wrapper)queryWrapper);
        return paginationTime.setData(userIpage.getRecords(), page.getTotal());
    }

    @Override
    public EmailConfigEntity getConfigInfo() {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EmailConfigEntity::getCreatorUserId, (Object)userId);
        return (EmailConfigEntity)this.emailConfigService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public EmailConfigEntity getConfigInfo(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EmailConfigEntity::getCreatorUserId, (Object)userId);
        return (EmailConfigEntity)this.emailConfigService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Object getInfo(String id) {
        EmailSendEntity object;
        EmailReceiveEntity receiveInfo = (EmailReceiveEntity)this.getById((Serializable)((Object)id));
        if (receiveInfo != null) {
            receiveInfo.setBodyText(receiveInfo.getBodyText());
            receiveInfo.setIsRead(Integer.valueOf(1));
            receiveInfo.setLastModifyTime(new Date());
            receiveInfo.setLastModifyUserId(this.userProvider.get().getUserId());
            this.updateById(receiveInfo);
            object = receiveInfo;
        } else {
            EmailSendEntity sendInfo;
            object = sendInfo = (EmailSendEntity)this.emailSendService.getById((Serializable)((Object)id));
        }
        return object;
    }

    @Override
    public boolean delete(String id) {
        Object object = this.getInfo(id);
        if (object != null && object instanceof EmailReceiveEntity) {
            EmailConfigEntity mailConfig = this.getConfigInfo();
            EmailReceiveEntity mailReceiveEntity = (EmailReceiveEntity)object;
            MailAccount mailAccount = new MailAccount();
            mailAccount.setAccount(mailConfig.getAccount());
            mailAccount.setPassword(mailConfig.getPassword());
            mailAccount.setPop3Port(mailConfig.getPop3Port().intValue());
            mailAccount.setPop3Host(mailConfig.getPop3Host());
            this.pop3Util.deleteMessage(mailAccount, mailReceiveEntity.getMId());
            this.removeById((Serializable)((Object)mailReceiveEntity.getId()));
            return true;
        }
        if (object != null) {
            EmailSendEntity entity = (EmailSendEntity)object;
            this.emailSendService.removeById((Serializable)((Object)entity.getId()));
            return true;
        }
        return false;
    }

    @Override
    @DSTransactional
    public void saveDraft(EmailSendEntity entity) {
        entity.setState(-1);
        if (entity.getId() != null) {
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(this.userProvider.get().getUserId());
            this.emailSendService.updateById(entity);
        } else {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
            this.emailSendService.save(entity);
        }
    }

    @Override
    public boolean receiveRead(String id, int isRead) {
        EmailReceiveEntity entity = (EmailReceiveEntity)this.getInfo(id);
        if (entity != null) {
            entity.setIsRead(Integer.valueOf(isRead));
            return this.updateById(entity);
        }
        return false;
    }

    @Override
    public boolean receiveStarred(String id, int isStarred) {
        EmailReceiveEntity entity = (EmailReceiveEntity)this.getInfo(id);
        if (entity != null) {
            entity.setStarred(Integer.valueOf(isStarred));
            return this.updateById(entity);
        }
        return false;
    }

    @Override
    public void saveConfig(EmailConfigEntity configEntity) throws DataException {
        EmailConfigEntity emailConfigEntity = this.getConfigInfo(this.userProvider.get().getUserId());
        if (emailConfigEntity == null) {
            configEntity.setId(RandomUtil.uuId());
            configEntity.setCreatorTime(new Date());
            configEntity.setCreatorUserId(this.userProvider.get().getUserId());
            this.emailConfigService.save(configEntity);
        } else if (this.userProvider.get().getUserId() != null) {
            configEntity.setId(emailConfigEntity.getId());
            this.emailConfigService.updateById(configEntity);
        } else {
            throw new DataException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
    }

    @Override
    public int saveSent(EmailSendEntity entity, EmailConfigEntity mailConfig) {
        int flag = 1;
        List attachmentList = JsonUtil.getJsonToList((String)entity.getAttachment(), MailFile.class);
        String temporaryFile = this.configValueUtil.getTemporaryFilePath();
        String mailFilePath = this.configValueUtil.getEmailFilePath();
        for (MailFile mailFile : attachmentList) {
            UploadUtil.copyObject((String)this.configValueUtil.getFileType(), (String)temporaryFile, (String)mailFile.getFileId(), (String)mailFilePath, (String)mailFile.getFileId());
        }
        try {
            MailModel mailModel = new MailModel();
            mailModel.setFrom(entity.getSender());
            mailModel.setRecipient(entity.getRecipient());
            mailModel.setCc(entity.getCc());
            mailModel.setBcc(entity.getBcc());
            mailModel.setSubject(entity.getSubject());
            mailModel.setBodyText(entity.getBodyText());
            mailModel.setAttachment(attachmentList);
            mailModel.setFromName(mailConfig.getSenderName());
            MailAccount mailAccount = new MailAccount();
            mailAccount.setAccount(mailConfig.getAccount());
            mailAccount.setPassword(mailConfig.getPassword());
            mailAccount.setPop3Host(mailConfig.getPop3Host());
            mailAccount.setPop3Port(mailConfig.getPop3Port().intValue());
            mailAccount.setSmtpHost(mailConfig.getSmtpHost());
            mailAccount.setSmtpPort(mailConfig.getSmtpPort().intValue());
            mailAccount.setSsl(Boolean.valueOf(mailConfig.getEmailSsl() == 1));
            mailAccount.setAccountName(mailConfig.getSenderName());
            SmtpUtil smtpUtil = new SmtpUtil(mailAccount);
            smtpUtil.sendMail(this.configValueUtil.getFileType(), mailFilePath, mailModel);
            flag = 0;
            if (entity.getId() != null) {
                entity.setState(1);
                this.emailSendService.updateById(entity);
            } else {
                entity.setId(RandomUtil.uuId());
                entity.setCreatorUserId(this.userProvider.get().getUserId());
                if (mailConfig.getAccount() != null) {
                    entity.setSender(mailConfig.getAccount());
                }
                entity.setState(1);
                this.emailSendService.save(entity);
            }
        }
        catch (Exception e) {
            for (MailFile mailFile : attachmentList) {
                FileUtil.deleteFile((String)(mailFilePath + mailFile.getFileId()));
            }
            log.error(e.getMessage());
        }
        return flag;
    }

    @Override
    @DSTransactional
    public int receive(EmailConfigEntity mailConfig) {
        MailAccount mailAccount = new MailAccount();
        mailAccount.setAccount(mailConfig.getAccount());
        mailAccount.setPassword(mailConfig.getPassword());
        mailAccount.setPop3Host(mailConfig.getPop3Host());
        mailAccount.setPop3Port(mailConfig.getPop3Port().intValue());
        mailAccount.setSmtpHost(mailConfig.getSmtpHost());
        mailAccount.setSmtpPort(mailConfig.getSmtpPort().intValue());
        if ("1".equals(mailConfig.getEmailSsl().toString())) {
            mailAccount.setSsl(Boolean.valueOf(true));
        } else {
            mailAccount.setSsl(Boolean.valueOf(false));
        }
        Map map = this.pop3Util.popMail(mailAccount);
        int receiveCount = 0;
        if (map.get("receiveCount") != null) {
            receiveCount = (Integer)map.get("receiveCount");
        }
        List mailList = new ArrayList();
        if (map.get("mailList") != null) {
            mailList = (List)map.get("mailList");
        }
        if (mailList.size() > 0) {
            List mids = mailList.stream().map(u -> u.getMId()).collect(Collectors.toList());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().in(EmailReceiveEntity::getMId, mids);
            List emails = this.list((Wrapper)wrapper);
            this.remove((Wrapper)wrapper);
            for (int i = 0; i < mailList.size(); ++i) {
                EmailReceiveEntity entity = (EmailReceiveEntity)mailList.get(i);
                entity.setCreatorUserId(this.userProvider.get().getUserId());
                String str = "[\\ud800" + File.separator + "udc00-\\udbff\\udfff" + File.separator + "ud800-\\udfff]";
                entity.setBodyText(entity.getBodyText().replaceAll(str, ""));
                int stat = emails.stream().anyMatch(m -> m.getMId().equals(entity.getMId())) ? emails.stream().filter(m -> m.getMId().equals(entity.getMId())).findFirst().get().getIsRead() : 0;
                long count = emails.stream().filter(m -> m.getMId().equals(entity.getMId())).count();
                entity.setIsRead(Integer.valueOf(stat));
                if (count != 0L) {
                    --receiveCount;
                }
                this.save(entity);
            }
        }
        return receiveCount;
    }
}

