/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ProductgoodsEntity;
import com.bringspring.extend.mapper.ProductgoodsMapper;
import com.bringspring.extend.model.productgoods.ProductgoodsPagination;
import com.bringspring.extend.service.ProductgoodsService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductgoodsServiceImpl
extends ServiceImpl<ProductgoodsMapper, ProductgoodsEntity>
implements ProductgoodsService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ProductgoodsEntity> getGoodList(String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)type)) {
            queryWrapper.lambda().eq(ProductgoodsEntity::getType, (Object)type);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProductgoodsEntity> getList(ProductgoodsPagination goodsPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)goodsPagination.getCode())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getCode, (Object)goodsPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)goodsPagination.getFullName())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getFullName, (Object)goodsPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)goodsPagination.getClassifyId())) {
            queryWrapper.lambda().like(ProductgoodsEntity::getClassifyId, (Object)goodsPagination.getClassifyId());
        }
        if (StringUtils.isNotEmpty((String)goodsPagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ProductgoodsEntity::getFullName, (Object)goodsPagination.getKeyword())).or()).like(ProductgoodsEntity::getCode, (Object)goodsPagination.getKeyword())).or()).like(ProductgoodsEntity::getProductSpecification, (Object)goodsPagination.getKeyword());
            });
        }
        if (StringUtils.isEmpty((String)goodsPagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(ProductgoodsEntity::getId);
        } else {
            queryWrapper = "asc".equals(goodsPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)goodsPagination.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)goodsPagination.getSidx());
        }
        Page page = new Page(goodsPagination.getCurrentPage(), goodsPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return goodsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public ProductgoodsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProductgoodsEntity::getId, (Object)id);
        return (ProductgoodsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ProductgoodsEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setCreatorTime(new Date());
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProductgoodsEntity entity) {
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        entity.setLastModifyTime(new Date());
        return this.updateById(entity);
    }

    @Override
    public void delete(ProductgoodsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

