/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.model.YozoFileParams;
import com.bringspring.files.service.YozoService;
import com.bringspring.files.utils.SplicingUrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YozoServiceImpl
extends ServiceImpl<FileMapper, FileEntity>
implements YozoService {
    @Autowired
    private FileMapper fileMapper;

    @Override
    public String getPreviewUrl(YozoFileParams params) {
        String previewUrl = SplicingUrlUtil.getPreviewUrl(params);
        return previewUrl;
    }

    @Override
    public ActionResult saveFileId(String fileVersionId, String fileId, String fileName) {
        FileEntity fileEntity = new FileEntity();
        fileEntity.setFileId(fileId);
        fileEntity.setFileName(fileName);
        fileEntity.setFileVersionId(fileVersionId);
        fileEntity.setType("create");
        this.save(fileEntity);
        return ActionResult.success((String)"\u65b0\u5efa\u6587\u6863\u6210\u529f");
    }

    @Override
    public FileEntity selectByName(String fileNa) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(FileEntity::getFileName, (Object)fileNa);
        return (FileEntity)this.getOne((Wrapper)wrapper);
    }

    @Override
    public ActionResult saveFileIdByHttp(String fileVersionId, String fileId, String fileUrl) {
        String fileName = "";
        String url = "";
        String name = "";
        try {
            url = URLDecoder.decode(fileUrl, "UTF-8");
            fileName = url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url.substring(url.lastIndexOf("\\") + 1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"F_Url", (Object)url);
        Long total = this.fileMapper.selectCount((Wrapper)wrapper);
        if (total == 0L) {
            name = fileName;
        } else {
            String t = total.toString();
            name = fileName + "(" + t + ")";
        }
        FileEntity fileEntity = new FileEntity();
        fileEntity.setType(url.contains("http") ? "http" : "local");
        fileEntity.setFileVersionId(fileVersionId);
        fileEntity.setFileId(fileId);
        fileEntity.setFileName(name);
        fileEntity.setUrl(url);
        this.fileMapper.insert(fileEntity);
        return ActionResult.success((String)"\u65b0\u5efa\u6587\u6863\u6210\u529f");
    }

    @Override
    public ActionResult deleteFileByVersionId(String versionId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"F_FileVersion", (Object)versionId);
        int i = this.fileMapper.delete((Wrapper)wrapper);
        if (i == 1) {
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public FileEntity selectByVersionId(String fileVersionId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"F_FileVersion", (Object)fileVersionId);
        FileEntity fileEntity = (FileEntity)this.fileMapper.selectOne((Wrapper)wrapper);
        return fileEntity;
    }

    @Override
    public ActionResult deleteBatch(String[] versions) {
        for (String version : versions) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"F_FileVersion", (Object)version);
            int i = this.fileMapper.delete((Wrapper)wrapper);
            if (i != 0) continue;
            return ActionResult.fail((String)("\u5220\u9664\u6587\u4ef6:" + version + "\u5931\u8d25"));
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @Override
    public void editFileVersion(String oldFileId, String newFileId) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"F_FileVersion", (Object)oldFileId);
        FileEntity fileEntity = new FileEntity();
        fileEntity.setFileVersionId(newFileId);
        fileEntity.setOldFileVersionId(oldFileId);
        this.fileMapper.update(fileEntity, (Wrapper)wrapper);
    }

    @Override
    public List<FileEntity> getAllList(PaginationVO pageModel) {
        Page page = new Page(pageModel.getCurrentPage().longValue(), pageModel.getPageSize().longValue());
        IPage iPage = this.fileMapper.selectPage((IPage)page, null);
        return iPage.getRecords();
    }
}

