package com.bringspring.files.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.param.FileIdParam;
import com.bringspring.files.param.FilePageParam;
import com.bringspring.files.service.FileService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import javax.validation.constraints.NotEmpty;

import java.util.List;

@Slf4j
@Api(tags = "公共", value = "file")
@RestController
@RequestMapping("/api/files")
public class FileController {


    @Resource
    private FileService fileService;

    @Autowired
    private BaseDataUtil baseDataUtil;


    /**
     * 获取文件分页列表
     */
    @Operation(summary = "获取文件分页列表")
    @GetMapping("/page")
    public ActionResult page(FilePageParam filePageParam) {
        List<FileEntity> list = fileService.getList(filePageParam);
        for (FileEntity file : list) {
            if (!ObjectUtil.isEmpty(file.getCreatorUserId())) {
                file.setCreatorUserName(baseDataUtil.userSelectValueNoAccount(file.getCreatorUserId()));
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = JsonUtil.getJsonToBean(filePageParam, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }

    /**
     * 删除文件
     */
    @Operation(summary = "删除文件")
    @PostMapping(value = "/delete")
    public ActionResult<String> delete(@RequestBody @NotEmpty(message = "集合不能为空") List<String> ids) {
        ActionResult res = fileService.delete(ids);
        return res;
    }
}
