package com.bringspring.files.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.param.FileIdParam;
import com.bringspring.files.param.FilePageParam;
import com.bringspring.files.service.FileService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class FileServiceImpl extends ServiceImpl<FileMapper, FileEntity> implements FileService {


    @Autowired
    private FileMapper fileMapper;

    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public String uploadFile(MultipartFile file) {
        return null;
    }

    @Override
    public List<FileEntity> getList(FilePageParam filePageParam) {


        QueryWrapper<FileEntity> fileQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(filePageParam.getFilename())) {
            fileQueryWrapper.lambda().like(FileEntity::getFileName, filePageParam.getFilename());
        }
        if (StringUtils.isNotEmpty(filePageParam.getEngine())) {
            fileQueryWrapper.lambda().eq(FileEntity::getEngine, filePageParam.getEngine());
        }else {
            String fileType = configValueUtil.getFileType();
            fileQueryWrapper.lambda().eq(FileEntity::getEngine, fileType.toUpperCase());
        }


        //排序
        fileQueryWrapper.lambda().orderByDesc(FileEntity::getCreatorTime);


        Page<FileEntity> page = new Page<>(filePageParam.getCurrentPage(), filePageParam.getPageSize());
        IPage<FileEntity> userIPage = this.page(page, fileQueryWrapper);
        return filePageParam.setData(userIPage.getRecords(), userIPage.getTotal());

    }

    @Override
    public void download(FileIdParam fileIdParam, HttpServletResponse response) throws IOException {
        FileEntity fe = this.queryEntity(fileIdParam.getId());
        File file = FileUtil.file(fe.getStoragePath());
        try {
            byte[] fileBytes = IoUtil.readBytes(FileUtil.getInputStream(file));
            response.setHeader("Content-Disposition", "attachment;filename=" + URLUtil.encode(fe.getFileName()));
            response.addHeader("Content-Length", "" + fileBytes.length);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("application/octet-stream;charset=UTF-8");
            IoUtil.write(response.getOutputStream(), true, fileBytes);
        } catch (IOException e) {
            log.error(">>> 文件下载异常：", e);
        }
    }

    @Override
    public FileEntity queryEntity(String id) {
        FileEntity fe = this.getById(id);
        return fe;
    }

    @Override
    public ActionResult delete(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return ActionResult.fail("请选中删除的文件");
        }
        List<String> delIds = new ArrayList<>();
        try {
            for (String id : ids) {
                FileEntity fe = queryEntity(id);
                String filePath = FilePathUtil.getFilePath(fe.getFileType());
                UploadUtil.removeFile(configValueUtil.getFileType(), fe.getObjName(), fe.getBucket(), filePath, fe.getSecondFilePath());
                delIds.add(id);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail("删除文件失败 请重试");
        } finally {
            fileMapper.deleteBatchIds(delIds);
        }
        return ActionResult.success("删除成功");

    }
}
