/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.model.FileForm;
import com.bringspring.files.model.YozoFileParams;
import com.bringspring.files.model.YozoParams;
import com.bringspring.files.service.YozoService;
import com.bringspring.files.utils.YozoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping
@Api(tags={"\u5728\u7ebf\u6587\u6863\u9884\u89c8"}, value="\u6587\u4ef6\u5728\u7ebf\u9884\u89c8")
public class YozoFileController {
    @Autowired
    private YozoService yozoService;
    @Autowired
    private YozoUtils yozoUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/api/file/getViewUrlWebPath"})
    @ApiOperation(value="\u6587\u6863\u9884\u89c8")
    public ActionResult getUrl(YozoFileParams params) {
        String previewUrl = XSSEscape.escape((String)this.yozoService.getPreviewUrl(params));
        return ActionResult.success((String)"success", (Object)previewUrl);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u672c\u5730\u6587\u4ef6")
    public ActionResult upload(@RequestPart(value="multipartFile") MultipartFile file) throws IOException {
        String result = this.yozoUtil.uploadFileInPreview(file.getInputStream(), file.getOriginalFilename());
        String fileName = file.getOriginalFilename();
        UploaderVO vo = UploaderVO.builder().name(fileName).build();
        Map map = JsonUtil.stringToMap((String)result);
        if ("\u64cd\u4f5c\u6210\u529f".equals(map.get("message"))) {
            Map dataMap = JsonUtil.stringToMap((String)String.valueOf(map.get("data")));
            String verId = String.valueOf(dataMap.get("fileVersionId"));
            vo.setFileVersionId(verId);
            return ActionResult.success((String)"Success", (Object)vo);
        }
        return ActionResult.fail((String)"\u4e0a\u4f20\u5931\u8d25!");
    }

    @GetMapping(value={"/newCreate"})
    @ApiOperation(value="\u65b0\u5efa\u6587\u4ef6")
    public ActionResult newCreate(String fileName, String templateType) {
        String fileNa = this.yozoUtil.getFileName(fileName, templateType);
        if (fileNa == null) {
            return ActionResult.fail((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u4ef6\u683c\u5f0f");
        }
        FileEntity fileEntity = this.yozoService.selectByName(fileNa);
        if (fileEntity != null) {
            return ActionResult.fail((String)"\u5b58\u5728\u540c\u540d\u6587\u4ef6\uff01");
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("templateType", new String[]{templateType});
        params.put("fileName", new String[]{fileName});
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        String url = YozoParams.CLOUD_DOMAIN + "/api/file/template?templateType=" + templateType + "&fileName=" + fileName + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        String s = HttpUtil.sendHttpPost((String)url);
        Map maps = (Map)JSONObject.parseObject((String)s, Map.class);
        Map fileMap = (Map)maps.get("data");
        String fileVersionId = (String)fileMap.get("fileVersionId");
        String fileId = (String)fileMap.get("fileId");
        ActionResult back = this.yozoService.saveFileId(fileVersionId, fileId, fileNa);
        FileUtil.createFile((String)this.configValueUtil.getDocumentPreviewPath(), (String)fileNa);
        return back;
    }

    @GetMapping(value={"/uploadByHttp"})
    @ApiOperation(value="http\u4e0a\u4f20\u6587\u4ef6")
    public ActionResult uploadByHttp(String fileUrl) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fileUrl", new String[]{fileUrl});
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        String url = YozoParams.CLOUD_DOMAIN + "/api/file/http?fileUrl=" + fileUrl + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        String s = HttpUtil.sendHttpPost((String)url);
        Map maps = (Map)JSONObject.parseObject((String)s, Map.class);
        Map fileMap = (Map)maps.get("data");
        String fileVersionId = (String)fileMap.get("fileVersionId");
        String fileId = (String)fileMap.get("fileId");
        ActionResult back = this.yozoService.saveFileIdByHttp(fileVersionId, fileId, fileUrl);
        return back;
    }

    @GetMapping(value={"/downloadFile"})
    @ApiOperation(value="\u6c38\u4e2d\u4e0b\u8f7d\u6587\u4ef6")
    public String downloadFile(String fileVersionId) {
        String newFileVersionId = XSSEscape.escape((String)fileVersionId);
        FileEntity fileEntity = this.yozoService.selectByVersionId(newFileVersionId);
        if (fileEntity == null) {
            return "\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6";
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fileVersionId", new String[]{newFileVersionId});
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        String url = YozoParams.CLOUD_DOMAIN + "/api/file/download?fileVersionId=" + newFileVersionId + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        return url;
    }

    @GetMapping(value={"/deleteVersionFile"})
    @ApiOperation(value="\u5220\u9664\u6587\u4ef6\u7248\u672c")
    public ActionResult deleteVersion(String fileVersionId) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fileVersionId", new String[]{fileVersionId});
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        String url = YozoParams.CLOUD_DOMAIN + "/api/file/delete/version?fileVersionId=" + fileVersionId + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        String s = HttpUtil.sendHttpGet((String)url);
        Map maps = (Map)JSONObject.parseObject((String)s, Map.class);
        String fileName = this.yozoService.selectByVersionId(fileVersionId).getFileName();
        String path = this.configValueUtil.getDocumentPreviewPath() + fileName;
        if (FileUtil.fileIsFile((String)path)) {
            File file = new File(XSSEscape.escapePath((String)path));
            file.delete();
        }
        String versionId = (String)maps.get("data");
        ActionResult back = this.yozoService.deleteFileByVersionId(versionId);
        return back;
    }

    @GetMapping(value={"/batchDelete"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6587\u4ef6\u7248\u672c")
    public ActionResult batchDelete(String[] fileVersionIds) {
        ArrayList<String[]> asList = new ArrayList<String[]>(16);
        for (String fileVersionId : fileVersionIds) {
            String[] escape = XSSEscape.escape((String)fileVersionId);
            asList.add(escape);
        }
        String[] newFileVersionIds = asList.toArray(fileVersionIds);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fileVersionIds", newFileVersionIds);
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        StringBuilder fileVersionIdList = new StringBuilder();
        for (String s : newFileVersionIds) {
            String fileName = this.yozoService.selectByVersionId(s).getFileName();
            String path = this.configValueUtil.getDocumentPreviewPath() + fileName;
            File file = new File(XSSEscape.escapePath((String)path));
            file.delete();
            fileVersionIdList.append("fileVersionIds=" + s + "&");
        }
        String list = fileVersionIdList.toString();
        String url = YozoParams.CLOUD_DOMAIN + "/api/file/delete/versions?" + list + "appId=" + YozoParams.APP_ID + "&sign=" + sign;
        String s = HttpUtil.sendHttpGet((String)url);
        ActionResult back = this.yozoService.deleteBatch(newFileVersionIds);
        return back;
    }

    @GetMapping(value={"/editFile"})
    @ApiOperation(value="\u5728\u7ebf\u7f16\u8f91")
    public ActionResult editFile(String fileVersionId) {
        String newFileVersionId = XSSEscape.escape((String)fileVersionId);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fileVersionId", new String[]{newFileVersionId});
        String sign = (String)this.yozoUtil.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, params).getData();
        String url = YozoParams.EDIT_DOMAIN + "/api/edit/file?fileVersionId=" + newFileVersionId + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        return ActionResult.success((String)"success", (Object)url);
    }

    @PostMapping(value={"/3rd/edit/callBack"})
    public Map<String, Object> editCallBack(String oldFileId, String newFileId, String message, Integer errorCode) {
        String escapeOldFileId = XSSEscape.escape((String)oldFileId);
        String escapeNewFileId = XSSEscape.escape((String)newFileId);
        String escapeMessage = XSSEscape.escape((String)message);
        this.yozoService.editFileVersion(escapeOldFileId, escapeNewFileId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("oldFileId", escapeOldFileId);
        result.put("newFileId", escapeNewFileId);
        result.put("message", escapeMessage);
        result.put("errorCode", errorCode);
        return result;
    }

    @PostMapping(value={"/documentList"})
    @ApiOperation(value="\u6587\u6863\u5217\u8868")
    public ActionResult documentList(@RequestBody PaginationVO pageModel) {
        PaginationVO pv = new PaginationVO();
        pv.setCurrentPage(pageModel.getCurrentPage());
        pv.setPageSize(pageModel.getPageSize());
        pv.setTotal(pageModel.getTotal());
        List<FileEntity> list = this.yozoService.getAllList(pv);
        List listVo = JsonUtil.getJsonToList(list, FileForm.class);
        return ActionResult.page((List)listVo, (PaginationVO)pv);
    }

    @GetMapping(value={"/updateFile"})
    @ApiOperation(value="/\u540c\u6b65\u6587\u4ef6\u7248\u672c\u5230\u672c\u5730")
    public ActionResult updateFile(String fileVersionId) throws Exception {
        FileEntity fileEntity = this.yozoService.selectByVersionId(fileVersionId);
        String fileName = fileEntity.getFileName();
        String path = this.configValueUtil.getDocumentPreviewPath() + fileName;
        if (FileUtil.fileIsFile((String)path)) {
            File file = new File(XSSEscape.escapePath((String)path));
            file.delete();
        }
        String fileUrl = this.downloadFile(fileVersionId);
        this.yozoUtil.downloadFile(fileUrl, path);
        return ActionResult.success((String)"\u66f4\u65b0\u5b8c\u6bd5");
    }
}

