/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.param.FileIdParam;
import com.bringspring.files.param.FilePageParam;
import com.bringspring.files.service.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
extends ServiceImpl<FileMapper, FileEntity>
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    private FileMapper fileMapper;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public String uploadFile(MultipartFile file) {
        return null;
    }

    @Override
    public List<FileEntity> getList(FilePageParam filePageParam) {
        QueryWrapper fileQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)filePageParam.getFilename())) {
            fileQueryWrapper.lambda().like(FileEntity::getFileName, (Object)filePageParam.getFilename());
        }
        if (StringUtils.isNotEmpty((String)filePageParam.getEngine())) {
            fileQueryWrapper.lambda().eq(FileEntity::getEngine, (Object)filePageParam.getEngine());
        } else {
            String fileType = this.configValueUtil.getFileType();
            fileQueryWrapper.lambda().eq(FileEntity::getEngine, (Object)fileType.toUpperCase());
        }
        fileQueryWrapper.lambda().orderByDesc(FileEntity::getCreatorTime);
        Page page = new Page(filePageParam.getCurrentPage(), filePageParam.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)fileQueryWrapper);
        return filePageParam.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public void download(FileIdParam fileIdParam, HttpServletResponse response) throws IOException {
        FileEntity fe = this.queryEntity(fileIdParam.getId());
        File file = FileUtil.file((String)fe.getStoragePath());
        try {
            byte[] fileBytes = IoUtil.readBytes((InputStream)FileUtil.getInputStream((File)file));
            response.setHeader("Content-Disposition", "attachment;filename=" + URLUtil.encode((String)fe.getFileName()));
            response.addHeader("Content-Length", "" + fileBytes.length);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("application/octet-stream;charset=UTF-8");
            IoUtil.write((OutputStream)response.getOutputStream(), (boolean)true, (byte[])fileBytes);
        }
        catch (IOException e) {
            log.error(">>> \u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public FileEntity queryEntity(String id) {
        FileEntity fe = (FileEntity)this.getById((Serializable)((Object)id));
        return fe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResult delete(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return ActionResult.fail((String)"\u8bf7\u9009\u4e2d\u5220\u9664\u7684\u6587\u4ef6");
        }
        ArrayList<String> delIds = new ArrayList<String>();
        try {
            for (String id : ids) {
                FileEntity fe = this.queryEntity(id);
                String filePath = FilePathUtil.getFilePath((String)fe.getFileType());
                UploadUtil.removeFile((String)this.configValueUtil.getFileType(), (String)fe.getObjName(), (String)fe.getBucket(), (String)filePath, (String)fe.getSecondFilePath());
                delIds.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ActionResult actionResult = ActionResult.fail((String)"\u5220\u9664\u6587\u4ef6\u5931\u8d25 \u8bf7\u91cd\u8bd5");
            return actionResult;
        }
        finally {
            this.fileMapper.deleteBatchIds(delIds);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

