package com.bringspring.files.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.config.constant.ConfigConst;
import com.bringspring.common.util.DateUtil;
import com.bringspring.files.utils.ZipUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;

@Component
public class FileBackUpTask {
    private static final Logger LOG = LoggerFactory.getLogger(FileBackUpTask.class);
    @Autowired
    private ConfigValueUtil configValueUtil;

    /**
     * 应用程序备份-暂时不用
     */
//    @JsbosTask(fullName = "执行应用程序备份计划", description = "执行应用程序备份计划")
//    public void backApplicationFilesUpZip() throws Exception {
//        // 获取Java进程的工作目录（与用户目录相同）
//        String workingDir = System.getProperty("user.dir");
//        //备份文件存储路径
//        String path = configValueUtil.getDataBackupFilePath();
//        path = StringUtils.replace(path,"\\",File.separator);
//        //压缩文件存储目录
//        String zipFileTargetPath = path + File.separator + DateUtil.daFormat(new Date());
//        Date date = new Date();
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
//        String format = simpleDateFormat.format(date);
//        //为了防止备份压缩应用程序死循环。先备份到根目录，然后再删除
//
//        //获得根目录
//        String osName = System.getProperty("os.name").toUpperCase();
//        String rootPath = "";
//        if (osName.contains("WINDOWS")) {
//            rootPath = workingDir.substring(0, 1).toUpperCase();
//
//        }else{
//            int firstCommaIndex = workingDir.indexOf("/");
//            int secondCommaIndex = workingDir.indexOf("/", firstCommaIndex + 1);
//            rootPath =workingDir.substring(firstCommaIndex + 1, secondCommaIndex);
//        }
//        String fileName = rootPath + "应用程序备份-" + format + ".zip";
//        ZipUtils.zipProjectFiles(workingDir, zipFileTargetPath, "rkkj88888888", fileName);
//        System.out.println("备份完成准备拷贝删除");
//        String copyPath = path + File.separator + DateUtil.daFormat(new Date()) + File.separator;
//        if(new File(copyPath).exists()){
//            FileUtil.copyFilesFromDir(new File(fileName),new File(copyPath),true);
//        }else{
//            FileUtil.mkdir(new File(copyPath));
//            FileUtil.copyFilesFromDir(new File(fileName),new File(copyPath),true);
//        }
//        //删除临时拷贝的文件
//        FileUtil.del(fileName);
//    }

    /**
     * 附件全量备份
     */
    @JsbosTask(fullName = "执行附件全量备份计划", description = "执行附件全量备份计划")
    public void backUpFilesZip() throws Exception {
        //备份文件存储路径
        String path = configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace(path, "\\", File.separator);
        //压缩文件存储目录
        String zipFileTargetPath = path + File.separator + DateUtil.daFormat(new Date());
        //调用zipProjectFiles压缩服务器附件 文件存放路径，密码，文件名称
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
        String format = simpleDateFormat.format(date);
        this.zipProjectFiles(zipFileTargetPath, "rkkj88888888", path + File.separator + DateUtil.daFormat(new Date()) + File.separator + "附件备份-" + format + ".zip");
    }

    /**
     * 附件增量备份
     */
    @JsbosTask(fullName = "执行附件增量备份计划", description = "执行附件增量备份计划")
    public void backUpSpikeFilesZip() throws Exception {
        //备份文件存储路径
        String path = configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace(path, "\\", File.separator);
        //压缩文件存储目录
        String zipFileTargetPath = path + File.separator + DateUtil.daFormat(new Date());
        //调用zipProjectFiles压缩服务器附件 文件存放路径，密码，文件名称
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
        String format = simpleDateFormat.format(date);
        this.zipSpikeProjectFiles(zipFileTargetPath, "rkkj88888888", path + File.separator + DateUtil.daFormat(new Date()) + File.separator + "附件增量备份-" + format + ".zip");
    }

    /**
     * 附件全量备份
     *
     * @param zipFileTargetPath
     * @param password
     * @param filesPath
     */
    private void zipProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        //文件存放路径
        //文档管理文件夹
        String documentFile = configValueUtil.getDocumentFilePath();
        //文档预览文件夹
        String documentPreview = configValueUtil.getDocumentPreviewPath();
        //IM聊天图片+语音存储文件夹
        String imContentFile = configValueUtil.getImContentFilePath();
        //许可文件夹
        String license = configValueUtil.getLicenseFilePath();
        //系统文件夹
        String systemFile = configValueUtil.getSystemFilePath();
        //代码模板文件夹
        String templateCode = configValueUtil.getTemplateCodePath();
        //文件模板文件夹
        String templateFile = configValueUtil.getTemplateFilePath();
        //用户头像文件夹
        String userAvatar = configValueUtil.getUserAvatarFilePath();
        //前端附件文件夹
        String webAnnexFile = configValueUtil.getWebAnnexFilePath();
        //大屏图片文件夹
        String biVisualPath = configValueUtil.getBiVisualPath();


        ZipUtils.zipProjectFiles(documentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(documentPreview, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(imContentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(license, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(systemFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(templateCode, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(templateFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(userAvatar, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(webAnnexFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(biVisualPath, zipFileTargetPath, password, filesPath);
    }

    /**
     * 附件增量备份
     *
     * @param zipFileTargetPath
     * @param password
     * @param filesPath
     */
    private void zipSpikeProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        //文件存放路径

        DateTime yesterday = DateUtil.yesterday();
        String dateStr = yesterday.toDateStr();
        dateStr = dateStr.replaceAll("-", Matcher.quoteReplacement(File.separator));

        //文档管理文件夹
        String documentFile = configValueUtil.getDocumentFilePath() + File.separator + dateStr;
        //文档预览文件夹
        String documentPreview = configValueUtil.getDocumentPreviewPath() + File.separator + dateStr;
        //IM聊天图片+语音存储文件夹
        String imContentFile = configValueUtil.getImContentFilePath() + File.separator + dateStr;
        //许可文件夹
        String license = configValueUtil.getLicenseFilePath() + File.separator + dateStr;
        //系统文件夹
        String systemFile = configValueUtil.getSystemFilePath() + File.separator + dateStr;
        //代码模板文件夹
        String templateCode = configValueUtil.getTemplateCodePath() + File.separator + dateStr;
        //文件模板文件夹
        String templateFile = configValueUtil.getTemplateFilePath() + File.separator + dateStr;
        //用户头像文件夹
        String userAvatar = configValueUtil.getUserAvatarFilePath() + File.separator + dateStr;
        //前端附件文件夹
        String webAnnexFile = configValueUtil.getWebAnnexFilePath() + File.separator + dateStr;
        //大屏图片文件夹
        String biVisualPath = configValueUtil.getBiVisualPath() + File.separator + dateStr;

        String dackUpFilePath = configValueUtil.getDataBackupFilePath() + File.separator + "tempZipFile";
        String zipDocumentFile = dackUpFilePath + File.separator + ConfigConst.DOCUMENT_FOLDER;
        String zipDocumentPreview = dackUpFilePath + File.separator + ConfigConst.DOCUMENT_PREVIEW_FOLDER;
        String zipIMContentFile = dackUpFilePath + File.separator + ConfigConst.IM_CONTENT_FOLDER;
        String zipLicense = dackUpFilePath + File.separator + ConfigConst.LICENSE_FILE_PATH;
        String zipSystemFile = dackUpFilePath + File.separator + ConfigConst.SYSTEM_FOLDER;
        String zipTemplateCode = dackUpFilePath + File.separator + ConfigConst.TEMPLATE_CODE_FOLDER;
        String zipTemplateFile = dackUpFilePath + File.separator + ConfigConst.TEMPLATE_FOLDER;
        String zipUserAvatar = dackUpFilePath + File.separator + ConfigConst.USER_AVATAR_FOLDER;
        String zipWebAnnexFile = dackUpFilePath + File.separator + ConfigConst.WEB_ANNEX_FOLDER;
        String zipBiVisualPath = dackUpFilePath + File.separator + ConfigConst.BI_VISUAL_FOLDER;


        //文档管理文件夹临时
        String tempDocumentFile = zipDocumentFile + File.separator + dateStr;
        //文档预览文件夹
        String tempDocumentPreview = zipDocumentPreview + File.separator + dateStr;
        //IM聊天图片+语音存储文件夹临时
        String tempIMContentFile = zipIMContentFile + File.separator + dateStr;
        //许可文件夹临时
        String tempLicense = zipLicense + File.separator + dateStr;
        //系统文件夹临时
        String tempSystemFile = zipSystemFile + File.separator + dateStr;
        //代码模板文件夹临时
        String tempTemplateCode = zipTemplateCode + File.separator + dateStr;
        //文件模板文件夹临时
        String tempTemplateFile = zipTemplateFile + File.separator + dateStr;
        //用户头像文件夹临时
        String tempUserAvatar = zipUserAvatar + File.separator + dateStr;
        //前端附件文件夹临时
        String tempWebAnnexFile = zipWebAnnexFile + File.separator + dateStr;
        //大屏图片文件夹临时
        String tempBiVisualPath = zipBiVisualPath + File.separator + dateStr;

        //拷贝文件
        if (new File(documentFile).exists()) {
            FileUtil.copyFilesFromDir(new File(documentFile), new File(tempDocumentFile), true);
        } else {
            FileUtil.mkdir(new File(tempDocumentFile));
        }
        if (new File(documentPreview).exists()) {
            FileUtil.copyFilesFromDir(new File(documentPreview), new File(tempDocumentPreview), true);
        } else {
            FileUtil.mkdir(new File(tempDocumentPreview));
        }
        if (new File(imContentFile).exists()) {
            FileUtil.copyFilesFromDir(new File(imContentFile), new File(tempIMContentFile), true);
        } else {
            FileUtil.mkdir(new File(tempIMContentFile));
        }
        if (new File(license).exists()) {
            FileUtil.copyFilesFromDir(new File(license), new File(tempLicense), true);
        } else {
            FileUtil.mkdir(new File(tempLicense));
        }
        if (new File(systemFile).exists()) {
            FileUtil.copyFilesFromDir(new File(systemFile), new File(tempSystemFile), true);
        } else {
            FileUtil.mkdir(new File(tempSystemFile));
        }
        if (new File(templateCode).exists()) {
            FileUtil.copyFilesFromDir(new File(templateCode), new File(tempTemplateCode), true);
        } else {
            FileUtil.mkdir(new File(tempTemplateCode));
        }
        if (new File(templateFile).exists()) {
            FileUtil.copyFilesFromDir(new File(templateFile), new File(tempTemplateFile), true);
        } else {
            FileUtil.mkdir(new File(tempTemplateFile));
        }
        if (new File(userAvatar).exists()) {
            FileUtil.copyFilesFromDir(new File(userAvatar), new File(tempUserAvatar), true);
        } else {
            FileUtil.mkdir(new File(tempUserAvatar));
        }
        if (new File(webAnnexFile).exists()) {
            FileUtil.copyFilesFromDir(new File(webAnnexFile), new File(tempWebAnnexFile), true);
        } else {
            FileUtil.mkdir(new File(tempWebAnnexFile));
        }
        if (new File(biVisualPath).exists()) {
            FileUtil.copyFilesFromDir(new File(biVisualPath), new File(tempBiVisualPath), true);
        } else {
            FileUtil.mkdir(new File(tempBiVisualPath));
        }

        //压缩文件
        ZipUtils.zipProjectFiles(zipDocumentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipDocumentPreview, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipIMContentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipLicense, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipSystemFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipTemplateCode, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipTemplateFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipUserAvatar, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipWebAnnexFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipBiVisualPath, zipFileTargetPath, password, filesPath);

        //删除临时拷贝的文件
        FileUtil.del(dackUpFilePath);
    }
}
