package com.bringspring.files.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/5/13
 */
@Data
@TableName("BASE_FILE")
public class FileEntity {
    /**
     * 主键
     */
    @TableId("id")
    private String fileId;

    /**
     * 文件编辑版本
     */
    @TableField("file_version")
    private String fileVersionId;

    /**
     * 文件名
     */
    @TableField("file_name")
    private String fileName;

    /**
     * 文件上传方式
     */
    @TableField("type")
    private String type;

    /**
     * 上传的url
     */
    @TableField("url")
    private String url;

    /**
     * 存储引擎
     */
    @ApiModelProperty(value = "存储引擎")
    private String engine;

    /**
     * 存储桶
     */
    @ApiModelProperty(value = "存储桶")
    private String bucket;


    /**
     * 文件后缀
     */
    @ApiModelProperty(value = "文件后缀")
    private String suffix;


    /**
     * 文件大小（格式化后）
     */
    @ApiModelProperty(value = "文件大小（格式化后）")
    @TableField(value = "size_info")
    private String sizeInfo;

    /**
     * 文件的对象名（唯一名称）
     */
    @ApiModelProperty(value = "文件的对象名（唯一名称）")
    @TableField(value = "obj_name")
    private String objName;

    /**
     * 文件存储路径
     */
    @TableField(value = "storage_path")
    @ApiModelProperty(value = "文件存储路径")
    private String storagePath;


    /**
     * 图片缩略图
     */
    @ApiModelProperty(value = "图片缩略图")
    private String thumbnail;


    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;
    @TableField(exist = false)
    private String creatorUserName;

    /**
     * 文件md5
     */
    @TableField(value = "file_digest")
    @ApiModelProperty(value = "文件md5")
    private String fileDigest;

    /**
     * 文件二级存储路径
     */
    @TableField(value = "second_file_path")
    @ApiModelProperty(value = "文件二级存储路径")
    private String secondFilePath;

    /**
     * 文件一级存储路径 对应FileTypeEnum枚举类
     */
    @TableField(value = "file_type")
    @ApiModelProperty(value = "文件一级存储路径 对应FileTypeEnum枚举类")
    private String fileType;

    /**
     * 模块类型
     */
    @TableField(value = "modular")
    @ApiModelProperty(value = "模块类型")
    private String modular;


}
