/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.files.utils.ZipUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileBackUpTask {
    private static final Logger LOG = LoggerFactory.getLogger(FileBackUpTask.class);
    @Autowired
    private ConfigValueUtil configValueUtil;

    @JsbosTask(fullName="\u6267\u884c\u9644\u4ef6\u5168\u91cf\u5907\u4efd\u8ba1\u5212", description="\u6267\u884c\u9644\u4ef6\u5168\u91cf\u5907\u4efd\u8ba1\u5212")
    public void backUpFilesZip() throws Exception {
        String path = this.configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace((String)path, (String)"\\", (String)File.separator);
        String zipFileTargetPath = path + File.separator + DateUtil.daFormat((Date)new Date());
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
        String format = simpleDateFormat.format(date);
        this.zipProjectFiles(zipFileTargetPath, "rkkj88888888", path + File.separator + DateUtil.daFormat((Date)new Date()) + File.separator + "\u9644\u4ef6\u5907\u4efd-" + format + ".zip");
    }

    @JsbosTask(fullName="\u6267\u884c\u9644\u4ef6\u589e\u91cf\u5907\u4efd\u8ba1\u5212", description="\u6267\u884c\u9644\u4ef6\u589e\u91cf\u5907\u4efd\u8ba1\u5212")
    public void backUpSpikeFilesZip() throws Exception {
        String path = this.configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace((String)path, (String)"\\", (String)File.separator);
        String zipFileTargetPath = path + File.separator + DateUtil.daFormat((Date)new Date());
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
        String format = simpleDateFormat.format(date);
        this.zipSpikeProjectFiles(zipFileTargetPath, "rkkj88888888", path + File.separator + DateUtil.daFormat((Date)new Date()) + File.separator + "\u9644\u4ef6\u589e\u91cf\u5907\u4efd-" + format + ".zip");
    }

    private void zipProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        String documentFile = this.configValueUtil.getDocumentFilePath();
        String documentPreview = this.configValueUtil.getDocumentPreviewPath();
        String imContentFile = this.configValueUtil.getImContentFilePath();
        String license = this.configValueUtil.getLicenseFilePath();
        String systemFile = this.configValueUtil.getSystemFilePath();
        String templateCode = this.configValueUtil.getTemplateCodePath();
        String templateFile = this.configValueUtil.getTemplateFilePath();
        String userAvatar = this.configValueUtil.getUserAvatarFilePath();
        String webAnnexFile = this.configValueUtil.getWebAnnexFilePath();
        String biVisualPath = this.configValueUtil.getBiVisualPath();
        ZipUtils.zipProjectFiles(documentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(documentPreview, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(imContentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(license, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(systemFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(templateCode, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(templateFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(userAvatar, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(webAnnexFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(biVisualPath, zipFileTargetPath, password, filesPath);
    }

    private void zipSpikeProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        DateTime yesterday = DateUtil.yesterday();
        String dateStr = yesterday.toDateStr();
        dateStr = dateStr.replaceAll("-", Matcher.quoteReplacement(File.separator));
        String documentFile = this.configValueUtil.getDocumentFilePath() + File.separator + dateStr;
        String documentPreview = this.configValueUtil.getDocumentPreviewPath() + File.separator + dateStr;
        String imContentFile = this.configValueUtil.getImContentFilePath() + File.separator + dateStr;
        String license = this.configValueUtil.getLicenseFilePath() + File.separator + dateStr;
        String systemFile = this.configValueUtil.getSystemFilePath() + File.separator + dateStr;
        String templateCode = this.configValueUtil.getTemplateCodePath() + File.separator + dateStr;
        String templateFile = this.configValueUtil.getTemplateFilePath() + File.separator + dateStr;
        String userAvatar = this.configValueUtil.getUserAvatarFilePath() + File.separator + dateStr;
        String webAnnexFile = this.configValueUtil.getWebAnnexFilePath() + File.separator + dateStr;
        String biVisualPath = this.configValueUtil.getBiVisualPath() + File.separator + dateStr;
        String dackUpFilePath = this.configValueUtil.getDataBackupFilePath() + File.separator + "tempZipFile";
        String zipDocumentFile = dackUpFilePath + File.separator + "DocumentFile";
        String zipDocumentPreview = dackUpFilePath + File.separator + "DocumentPreview";
        String zipIMContentFile = dackUpFilePath + File.separator + "IMContentFile";
        String zipLicense = dackUpFilePath + File.separator + "License";
        String zipSystemFile = dackUpFilePath + File.separator + "SystemFile";
        String zipTemplateCode = dackUpFilePath + File.separator + "TemplateCode";
        String zipTemplateFile = dackUpFilePath + File.separator + "TemplateFile";
        String zipUserAvatar = dackUpFilePath + File.separator + "UserAvatar";
        String zipWebAnnexFile = dackUpFilePath + File.separator + "WebAnnexFile";
        String zipBiVisualPath = dackUpFilePath + File.separator + "BiVisualPath";
        String tempDocumentFile = zipDocumentFile + File.separator + dateStr;
        String tempDocumentPreview = zipDocumentPreview + File.separator + dateStr;
        String tempIMContentFile = zipIMContentFile + File.separator + dateStr;
        String tempLicense = zipLicense + File.separator + dateStr;
        String tempSystemFile = zipSystemFile + File.separator + dateStr;
        String tempTemplateCode = zipTemplateCode + File.separator + dateStr;
        String tempTemplateFile = zipTemplateFile + File.separator + dateStr;
        String tempUserAvatar = zipUserAvatar + File.separator + dateStr;
        String tempWebAnnexFile = zipWebAnnexFile + File.separator + dateStr;
        String tempBiVisualPath = zipBiVisualPath + File.separator + dateStr;
        if (new File(documentFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(documentFile), (File)new File(tempDocumentFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempDocumentFile));
        }
        if (new File(documentPreview).exists()) {
            FileUtil.copyFilesFromDir((File)new File(documentPreview), (File)new File(tempDocumentPreview), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempDocumentPreview));
        }
        if (new File(imContentFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(imContentFile), (File)new File(tempIMContentFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempIMContentFile));
        }
        if (new File(license).exists()) {
            FileUtil.copyFilesFromDir((File)new File(license), (File)new File(tempLicense), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempLicense));
        }
        if (new File(systemFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(systemFile), (File)new File(tempSystemFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempSystemFile));
        }
        if (new File(templateCode).exists()) {
            FileUtil.copyFilesFromDir((File)new File(templateCode), (File)new File(tempTemplateCode), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempTemplateCode));
        }
        if (new File(templateFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(templateFile), (File)new File(tempTemplateFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempTemplateFile));
        }
        if (new File(userAvatar).exists()) {
            FileUtil.copyFilesFromDir((File)new File(userAvatar), (File)new File(tempUserAvatar), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempUserAvatar));
        }
        if (new File(webAnnexFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(webAnnexFile), (File)new File(tempWebAnnexFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempWebAnnexFile));
        }
        if (new File(biVisualPath).exists()) {
            FileUtil.copyFilesFromDir((File)new File(biVisualPath), (File)new File(tempBiVisualPath), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempBiVisualPath));
        }
        ZipUtils.zipProjectFiles(zipDocumentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipDocumentPreview, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipIMContentFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipLicense, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipSystemFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipTemplateCode, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipTemplateFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipUserAvatar, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipWebAnnexFile, zipFileTargetPath, password, filesPath);
        ZipUtils.zipProjectFiles(zipBiVisualPath, zipFileTargetPath, password, filesPath);
        FileUtil.del((String)dackUpFilePath);
    }
}

