package com.bringspring.files.service;


import com.bringspring.common.base.ActionResult;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.param.FileIdParam;
import com.bringspring.files.param.FilePageParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public interface FileService {
    /**
     * MultipartFile文件上传，返回文件id
     **/
    String uploadFile(MultipartFile file);

    /**
     * 文件分页列表接口
     **/
    List<FileEntity> getList(FilePageParam filePageParam);

    /**
     * 下载文件
     **/
    void download(FileIdParam FileIdParam, HttpServletResponse response) throws IOException;


    /**
     * 获取文件详情
     *
     * @author fanpengxin
     */
    FileEntity queryEntity(String id);


    /**
     * 删除文件
     **/
    ActionResult delete(List<String> ids);
}
