/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.param.FilePageParam;
import com.bringspring.files.service.FileService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u516c\u5171"}, value="file")
@RestController
@RequestMapping(value={"/api/files"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Resource
    private FileService fileService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/page"})
    public ActionResult page(FilePageParam filePageParam) {
        List<FileEntity> list = this.fileService.getList(filePageParam);
        for (FileEntity file : list) {
            if (ObjectUtil.isEmpty((Object)file.getCreatorUserId())) continue;
            file.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(file.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)filePageParam), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6")
    @PostMapping(value={"/delete"})
    public ActionResult<String> delete(@RequestBody @NotEmpty(message="\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a") List<String> ids) {
        ActionResult res = this.fileService.delete(ids);
        return res;
    }
}

