/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.controller;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.LanguageVO;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.DesUtil;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.minio.MinioUploadUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.model.Chunk;
import com.bringspring.files.model.ChunkRes;
import com.bringspring.files.model.MergeChunkDto;
import com.bringspring.files.model.PreviewParams;
import com.bringspring.files.model.YozoParams;
import com.bringspring.files.utils.YozoUtils;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.OptimizeUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

@Tag(name="\u516c\u5171", description="file")
@RestController
@RequestMapping(value={"/api/file"})
public class UtilsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtilsController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private YozoUtils yozoUtils;
    @Autowired
    private MinioUploadUtil minioUploadUtil;
    @Autowired
    private FileMapper fileMapper;
    @Autowired
    private FileDownLogService filedownlogService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    private static boolean isPic(String fileSuffix) {
        return "gif".equals(fileSuffix = fileSuffix.toLowerCase()) || "jpg".equals(fileSuffix) || "jpeg".equals(fileSuffix) || "bmp".equals(fileSuffix) || "png".equals(fileSuffix) || "psd".equals(fileSuffix);
    }

    @Operation(summary="\u8bed\u8a00\u5217\u8868")
    @GetMapping(value={"/Language"})
    public ActionResult<ListVO<LanguageVO>> getList() {
        String dictionaryTypeId = "dc6b2542d94b407cac61ec1d59592901";
        List list = this.dictionaryDataService.getList(dictionaryTypeId);
        List language = JsonUtil.getJsonToList((Object)list, LanguageVO.class);
        ListVO vo = new ListVO();
        vo.setList(language);
        return ActionResult.success((Object)vo);
    }

    @NoDataSourceBind
    @Operation(summary="\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/ImageCode/{timestamp}"})
    public void imageCode(@PathVariable(value="timestamp") String timestamp) {
        DownUtil.downCode(null);
        this.cacheUtil.insert("shortCacheSpace", timestamp, ServletUtils.getSession().getAttribute("RANDOMCODEKEY"), 120L);
    }

    @NoDataSourceBind
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6/\u56fe\u7247")
    @PostMapping(value={"/Uploader/{type}"}, consumes={"multipart/form-data"})
    public ActionResult uploader(@RequestPart(value="file") MultipartFile file, @PathVariable(value="type") String type) {
        try {
            String fileType = UpUtil.getFileType((MultipartFile)file);
            if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)fileType)) {
                return ActionResult.fail((String)MsgCode.FA017.get());
            }
            UploaderVO vo = this.uploaderVO(file, type, file.getOriginalFilename());
            return ActionResult.success((Object)vo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6/\u56fe\u7247" + e.getMessage()));
        }
    }

    @NoDataSourceBind
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6/\u56fe\u7247")
    @PostMapping(value={"/Uploader/{modular}/{type}"}, consumes={"multipart/form-data"})
    public ActionResult uploader(@RequestPart(value="file") MultipartFile file, @PathVariable(value="modular") String modular, @PathVariable(value="type") String type) {
        try {
            String fileType = UpUtil.getFileType((MultipartFile)file);
            if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)fileType)) {
                return ActionResult.fail((String)MsgCode.FA017.get());
            }
            UploaderVO vo = this.uploaderVO(file, type, modular, file.getOriginalFilename());
            return ActionResult.success((Object)vo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6/\u56fe\u7247" + e.getMessage()));
        }
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @GetMapping(value={"/Download/{type}/{fileName}"})
    @NotCheckLogin
    public ActionResult<DownloadVO> downloadUrl(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName) {
        type = XSSEscape.escape((String)type);
        fileName = XSSEscape.escape((String)fileName);
        UserInfo userInfo = this.userProvider.get();
        if (!this.configValueUtil.getFileType().equals("storage")) {
            DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(userInfo.getUserId() + "#" + fileName + "#" + type))).build();
            return ActionResult.success((Object)vo);
        }
        String filePath = FilePathUtil.getFilePath((String)type) + fileName;
        if (FileUtil.fileIsFile((String)filePath)) {
            DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + fileName + "#" + type))).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.FA018.get());
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @GetMapping(value={"/Download/{type}/{year}/{month}/{day}/{modular}/{fileName}"})
    public ActionResult<DownloadVO> downloadUrl(@PathVariable(value="type") String type, @PathVariable(value="year") String year, @PathVariable(value="month") String month, @PathVariable(value="day") String day, @PathVariable(value="modular") String modular, @PathVariable(value="fileName") String fileName) {
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        type = XSSEscape.escape((String)type);
        fileName = XSSEscape.escape((String)fileName);
        UserInfo userInfo = this.userProvider.get();
        if (!this.configValueUtil.getFileType().equals("storage")) {
            DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(ServletUtils.getRequest().getHeader("Authorization") + "#" + fileName + "#" + type + "#" + secondFilePath))).build();
            return ActionResult.success((Object)vo);
        }
        String filePath = FilePathUtil.getFilePath((String)type) + fileName;
        if (FileUtil.fileIsFile((String)filePath)) {
            DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + fileName + "#" + type + "#" + secondFilePath))).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.FA018.get());
    }

    @NoDataSourceBind
    @NotCheckLogin
    @Operation(summary="\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @GetMapping(value={"/Download"})
    public void downloadFile() throws DataException {
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String name = request.getParameter("name");
        String fileNameAll = DesUtil.aesDecode((String)reqJson);
        if (!StringUtils.isEmpty((String)fileNameAll)) {
            String[] arr;
            String[] data = fileNameAll.split("#");
            String token = data.length > 0 ? data[0] : "";
            String fileName = data.length > 1 ? data[1] : "";
            String type = data.length > 2 ? data[2] : "";
            String secondFilePath = data.length > 3 ? data[3] : "";
            String bucketName = type.toLowerCase();
            String filePath = FilePathUtil.getFilePath((String)bucketName);
            if (StringUtils.isNotEmpty((String)filePath) && (arr = filePath.split("/|\\\\")).length > 0) {
                bucketName = arr[arr.length - 1];
            }
            if (StringUtils.isNotEmpty((String)secondFilePath)) {
                UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)bucketName, (String)filePath, (String)secondFilePath, (String)name);
            } else {
                UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)type, (String)filePath, (String)name);
            }
        }
    }

    @NoDataSourceBind
    @Operation(summary="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u94fe\u63a5")
    @GetMapping(value={"/DownloadModel"})
    public void downloadModel() throws DataException {
        String token;
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String fileNameAll = DesUtil.aesDecode((String)reqJson);
        if (!StringUtils.isEmpty((String)fileNameAll) && this.cacheUtil.exists("loginCacheSpace", token = fileNameAll.split("#")[0])) {
            String fileName = fileNameAll.split("#")[1];
            String filePath = this.configValueUtil.getTemplateFilePath();
            UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"templatefile", (String)filePath, null);
        }
    }

    @NoDataSourceBind
    @Operation(summary="\u5220\u9664\u5355\u4e2a\u6587\u4ef6")
    @GetMapping(value={"/remove/{type}/{fileName}"})
    public ActionResult delete(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName) {
        String filePath = FilePathUtil.getFilePath((String)type.toLowerCase());
        if ("im".equalsIgnoreCase(type)) {
            type = "imfile";
        } else if ("annex".equalsIgnoreCase(type)) {
            type = "annexpic";
        }
        UploadUtil.removeFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)type.toLowerCase(), (String)filePath);
        return ActionResult.success((String)MsgCode.SU003.getDesc());
    }

    @NoDataSourceBind
    @Operation(summary="\u5220\u9664\u5355\u4e2a\u6587\u4ef6")
    @GetMapping(value={"/remove/{type}/{year}/{month}/{day}/{modular}/{fileName}"})
    public ActionResult delete(@PathVariable(value="type") String type, @PathVariable(value="year") String year, @PathVariable(value="month") String month, @PathVariable(value="day") String day, @PathVariable(value="modular") String modular, @PathVariable(value="fileName") String fileName) {
        String[] arr;
        String bucketName = type.toLowerCase();
        String filePath = FilePathUtil.getFilePath((String)bucketName);
        if (StringUtils.isNotEmpty((String)filePath) && (arr = filePath.split("/|\\\\")).length > 0) {
            bucketName = arr[arr.length - 1];
        }
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        UploadUtil.removeFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)bucketName, (String)filePath, (String)secondFilePath);
        return ActionResult.success((String)MsgCode.SU003.getDesc());
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u56fe\u7247")
    @GetMapping(value={"/Image/{type}/{fileName}"})
    public void downLoadImg(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName) {
        String filePath = FilePathUtil.getFilePath((String)type.toLowerCase());
        if ("im".equalsIgnoreCase(type)) {
            type = "imfile";
        } else if ("annex".equalsIgnoreCase(type)) {
            type = "annexpic";
        }
        UploadUtil.writeImage((String)this.configValueUtil.getFileType(), (String)fileName, (String)type.toLowerCase(), (String)filePath);
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u56fe\u7247")
    @GetMapping(value={"/Image/{type}/{year}/{month}/{day}/{modular}/{fileName}"})
    @HandleLog(moduleName="\u6587\u4ef6\u7ba1\u7406", requestMethod="\u83b7\u53d6\u56fe\u7247")
    public void downLoadImg(@PathVariable(value="type") String type, @PathVariable(value="year") String year, @PathVariable(value="month") String month, @PathVariable(value="day") String day, @PathVariable(value="modular") String modular, @PathVariable(value="fileName") String fileName) {
        String[] arr;
        String bucketName = type.toLowerCase();
        String filePath = FilePathUtil.getFilePath((String)bucketName);
        if (StringUtils.isNotEmpty((String)filePath) && (arr = filePath.split("/|\\\\")).length > 0) {
            bucketName = arr[arr.length - 1];
        }
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        UploadUtil.writeImage((String)this.configValueUtil.getFileType(), (String)fileName, (String)bucketName, (String)filePath, (String)secondFilePath);
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6IM\u804a\u5929\u56fe\u7247")
    @GetMapping(value={"/IMImage/{fileName}"})
    public void imImage(@PathVariable(value="fileName") String fileName) {
        UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"imfile", (String)(FilePathUtil.getFilePath((String)"im") + fileName), null);
    }

    @NoDataSourceBind
    @Operation(summary="\u67e5\u770b\u56fe\u7247")
    @GetMapping(value={"/{type}/{fileName}"})
    public void img(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName) {
        Object filePath = this.configValueUtil.getBiVisualPath() + type + File.separator;
        if ("minio".equals(this.configValueUtil.getFileType())) {
            fileName = "/" + type + "/" + (String)fileName;
            filePath = this.configValueUtil.getBiVisualPath().substring(0, this.configValueUtil.getBiVisualPath().length() - 1);
        }
        UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"bivisualpath", (String)filePath, null);
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6IM\u804a\u5929\u8bed\u97f3")
    @GetMapping(value={"/IMVoice/{fileName}"})
    public void imVoice(@PathVariable(value="fileName") String fileName) {
        String paths = FilePathUtil.getFilePath((String)"im") + fileName.replaceAll("@", ".");
        UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"imfile", (String)paths, null);
    }

    @NoDataSourceBind
    @Operation(summary="app\u542f\u52a8\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/AppStartInfo/{appName}"})
    public ActionResult getAppStartInfo(@PathVariable(value="appName") String appName) {
        appName = XSSEscape.escape((String)appName);
        JSONObject object = new JSONObject();
        object.put("AppVersion", (Object)this.configValueUtil.getAppVersion());
        object.put("AppUpdateContent", (Object)this.configValueUtil.getAppUpdateContent());
        return ActionResult.success((Object)object);
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u56fe\u7247")
    @GetMapping(value={"/VisusalImg/{type}/{fileName}"})
    public void downVisusalImg(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName) {
        type = XSSEscape.escape((String)type);
        fileName = XSSEscape.escape((String)fileName);
        String filePath = FilePathUtil.getFilePath((String)"bivisualpath") + type + File.separator;
        if ("minio".equals(this.configValueUtil.getFileType())) {
            fileName = "/" + type + "/" + (String)fileName;
        }
        UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"bivisualpath", (String)filePath, null);
    }

    @NoDataSourceBind
    @Operation(summary="\u9884\u89c8\u6587\u4ef6")
    @GetMapping(value={"/Uploader/Preview"})
    @HandleLog(moduleName="\u6587\u4ef6\u7ba1\u7406", requestMethod="\u9884\u89c8\u6587\u4ef6")
    public ActionResult Preview(PreviewParams previewParams) {
        Object url;
        String allowPreviewType = this.configValueUtil.getAllowPreviewFileType();
        String[] fileType = allowPreviewType.split(",");
        String fileName = XSSEscape.escape((String)previewParams.getFileName());
        String docType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String s = Arrays.asList(fileType).stream().filter(type -> type.equals(docType)).findFirst().orElse(null);
        if (StringUtils.isEmpty((String)s)) {
            return ActionResult.fail((String)"\u9884\u89c8\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u89c4\u8303");
        }
        String type2 = "annex";
        String secondFilePath = StringUtils.isNotEmpty((String)previewParams.getSecondFilePath()) ? previewParams.getSecondFilePath() : "";
        String fileNameAll = previewParams.getFileDownloadUrl();
        if (!StringUtils.isEmpty((String)fileNameAll)) {
            String[] data = fileNameAll.split("/");
            String string = type2 = data.length > 4 ? data[4] : "";
        }
        if ("yozo".equals(this.configValueUtil.getPreviewType())) {
            if (StringUtils.isEmpty((String)previewParams.getFileVersionId())) {
                return ActionResult.fail((String)"\u9884\u89c8\u5931\u8d25,\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6");
            }
            String fileVersionId = XSSEscape.escape((String)previewParams.getFileVersionId());
            HashMap<String, String[]> parameter = new HashMap<String, String[]>();
            parameter.put("appId", new String[]{YozoParams.APP_ID});
            parameter.put("fileVersionId", new String[]{fileVersionId});
            String sign = (String)this.yozoUtils.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, parameter).getData();
            url = "http://eic.yozocloud.cn/api/view/file?fileVersionId=" + fileVersionId + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        } else {
            url = "local".equals(this.configValueUtil.getFileType()) ? YozoParams.DOMAINS + "/api/file/filedownload/" + type2 + "/" + secondFilePath + previewParams.getFileName() : this.minioUploadUtil.getFile(secondFilePath + fileName, type2);
            String fileUrl = Base64.encodeBase64String((byte[])((String)url).getBytes());
            url = this.configValueUtil.getKkFileUrl() + "onlinePreview?url=" + fileUrl;
        }
        return ActionResult.success((String)MsgCode.SU000.get(), (Object)url);
    }

    @NoDataSourceBind
    @Operation(summary="\u9884\u8f6c\u7801URL")
    @GetMapping(value={"/Uploader/getPreviewFileTaskUrl"})
    @HandleLog(moduleName="\u6587\u4ef6\u7ba1\u7406", requestMethod="\u9884\u89c8\u6587\u4ef6")
    public ActionResult getPreviewFileTaskUrl() {
        String url = this.configValueUtil.getKkFileUrl() + "addTask";
        return ActionResult.success((String)MsgCode.SU000.get(), (Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotCheckLogin
    @NoDataSourceBind
    @Operation(summary="kk\u672c\u5730\u6587\u4ef6\u9884\u89c8")
    @GetMapping(value={"/filedownload/{type}/{fileName}"})
    @HandleLog(moduleName="\u6587\u4ef6\u7ba1\u7406", requestMethod="kk\u672c\u5730\u6587\u4ef6\u9884\u89c8")
    public void filedownload(@PathVariable(value="type") String type, @PathVariable(value="fileName") String fileName, HttpServletResponse response) {
        String filePath = FilePathUtil.getFilePath((String)type) + fileName;
        ServletOutputStream os = null;
        if ("local".equals(this.configValueUtil.getFileType())) {
            File file = new File(filePath);
            try {
                os = response.getOutputStream();
                String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0]));
                response.setHeader("Content-Type", contentType);
                response.setHeader("Content-Dispostion", "attachment;filename=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
                FileInputStream fileInputStream = new FileInputStream(file);
                WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)os);
                FileChannel channel = fileInputStream.getChannel();
                channel.transferTo(0L, channel.size(), writableByteChannel);
                channel.close();
                os.flush();
                writableByteChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotCheckLogin
    @NoDataSourceBind
    @Operation(summary="kk\u672c\u5730\u6587\u4ef6\u9884\u89c8")
    @GetMapping(value={"/filedownload/{type}/**"})
    @HandleLog(moduleName="\u6587\u4ef6\u7ba1\u7406", requestMethod="\u6587\u4ef6\u4e0b\u8f7d")
    public void filedownload(@PathVariable(value="type") String type, HttpServletRequest request, HttpServletResponse response) {
        String uri = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String fileName = new AntPathMatcher().extractPathWithinPattern(pattern, uri);
        String filePath = FilePathUtil.getFilePath((String)type) + fileName;
        ServletOutputStream os = null;
        if ("local".equals(this.configValueUtil.getFileType())) {
            File file = new File(filePath);
            try {
                os = response.getOutputStream();
                String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0]));
                response.setHeader("Content-Type", contentType);
                response.setHeader("Content-Dispostion", "attachment;filename=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
                FileInputStream fileInputStream = new FileInputStream(file);
                WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)os);
                FileChannel channel = fileInputStream.getChannel();
                channel.transferTo(0L, channel.size(), writableByteChannel);
                channel.close();
                os.flush();
                writableByteChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NoDataSourceBind
    @Operation(summary="\u5206\u7247\u4e0a\u4f20\u83b7\u53d6")
    @GetMapping(value={"/chunk"})
    public ActionResult checkChunk(Chunk chunk) {
        String type = chunk.getExtension();
        if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)type)) {
            return ActionResult.fail((String)MsgCode.FA017.get());
        }
        String identifier = chunk.getIdentifier();
        String path = FilePathUtil.getFilePath((String)"temporary");
        String filePath = XSSEscape.escapePath((String)(path + identifier));
        List chunkFiles = FileUtil.getFile((File)new File(filePath));
        log.info("\u5206\u7247\u4e0a\u4f20\u662f\u5426\u6709\u7f13\u5b58\uff1a", (Object)chunkFiles);
        List<Integer> existsChunk = chunkFiles.stream().filter(f -> {
            if (f.getName().endsWith(".tmp")) {
                FileUtils.deleteQuietly((File)f);
                return false;
            }
            return true;
        }).map(f -> Integer.parseInt(f.getName().replace(chunk.getIdentifier().concat("-"), ""))).collect(Collectors.toList());
        boolean mergeFlag = existsChunk.size() == chunk.getTotalChunks().intValue();
        ChunkRes chunkRes = ChunkRes.builder().merge(mergeFlag).chunkNumbers(existsChunk).build();
        return ActionResult.success((Object)chunkRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoDataSourceBind
    @Operation(summary="\u5206\u7247\u4e0a\u4f20\u9644\u4ef6")
    @PostMapping(value={"/chunk"})
    public ActionResult upload(Chunk chunk, @RequestParam(value="file") MultipartFile file) {
        String type = chunk.getExtension();
        if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)type)) {
            return ActionResult.fail((String)MsgCode.FA017.get());
        }
        ChunkRes chunkRes = ChunkRes.builder().build();
        chunkRes.setMerge(false);
        File chunkFile = null;
        File chunkTmpFile = null;
        try {
            String filePath = FilePathUtil.getFilePath((String)"temporary");
            Integer chunkNumber = chunk.getChunkNumber();
            String identifier = chunk.getIdentifier();
            String chunkTempPath = filePath + identifier;
            File path = new File(chunkTempPath);
            if (!path.exists()) {
                path.mkdirs();
            }
            String chunkName = identifier.concat("-") + chunkNumber;
            String chunkTmpName = chunkName.concat(".tmp");
            chunkFile = new File(chunkTempPath, chunkName);
            chunkTmpFile = new File(chunkTempPath, chunkTmpName);
            if (chunkFile.exists() && chunkFile.length() == chunk.getCurrentChunkSize().longValue()) {
                System.out.println("\u8be5\u5206\u5757\u5df2\u7ecf\u4e0a\u4f20\uff1a" + chunkFile.getName());
            } else {
                InputStream inputStream = file.getInputStream();
                try {
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)chunkTmpFile);
                    chunkTmpFile.renameTo(chunkFile);
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            log.info("\u5206\u7247\u4e0a\u4f20\u6700\u540e\u770b\u662f\u5426merge\uff1a" + chunk.getChunkNumber(), (Object)chunk.getTotalChunks());
            chunkRes.setMerge(chunk.getChunkNumber().equals(chunk.getTotalChunks()));
        }
        catch (Exception e) {
            try {
                FileUtils.deleteQuietly(chunkTmpFile);
                FileUtils.deleteQuietly(chunkFile);
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
            return ActionResult.fail((String)"\u4e0a\u4f20\u5f02\u5e38");
        }
        return ActionResult.success((Object)chunkRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoDataSourceBind
    @Operation(summary="\u5206\u7247\u7ec4\u88c5")
    @PostMapping(value={"/merge"})
    public ActionResult merge(MergeChunkDto mergeChunkDto) {
        String identifier = mergeChunkDto.getIdentifier();
        String path = FilePathUtil.getFilePath((String)"temporary");
        String filePath = XSSEscape.escapePath((String)(path + identifier));
        String uuid = RandomUtil.uuId();
        String partFile = XSSEscape.escapePath((String)(path + uuid + "." + mergeChunkDto.getExtension()));
        UploaderVO vo = UploaderVO.builder().build();
        try {
            List mergeFileList = FileUtil.getFile((File)new File(filePath));
            FileOutputStream destTempfos = new FileOutputStream(partFile, true);
            try {
                for (int i = 0; i < mergeFileList.size(); ++i) {
                    String chunkName = identifier.concat("-") + (i + 1);
                    File files = new File(filePath, chunkName);
                    if (!files.exists()) continue;
                    FileUtils.copyFile((File)files, (OutputStream)destTempfos);
                }
                File partFiles = new File(partFile);
                if (partFiles.exists()) {
                    MultipartFile multipartFile = FileUtil.createFileItem((File)partFiles);
                    String type = mergeChunkDto.getType();
                    String modular = mergeChunkDto.getModular();
                    vo = StringUtils.isNotEmpty((String)modular) ? this.uploaderVO(multipartFile, type, modular, mergeChunkDto.getFileName()) : this.uploaderVO(multipartFile, type, mergeChunkDto.getFileName());
                    FileUtil.deleteTmp((MultipartFile)multipartFile);
                }
            }
            finally {
                if (Collections.singletonList(destTempfos).get(0) != null) {
                    destTempfos.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u5408\u5e76\u5206\u7247\u5931\u8d25:" + String.valueOf(e));
        }
        finally {
            FileUtils.deleteQuietly((File)new File(filePath));
            FileUtils.deleteQuietly((File)new File(partFile));
        }
        vo.setFileSize(mergeChunkDto.getFileSize());
        vo.setSecondFilePath(vo.getSecondFilePath());
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploaderVO uploaderVO(MultipartFile file, String type, String realName) throws IOException {
        String orgFileName = file.getOriginalFilename();
        String fileType = UpUtil.getFileType((MultipartFile)file);
        String fileName = DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + "." + fileType;
        if (type.equals("mail")) {
            type = "temporary";
        }
        String filePath = FilePathUtil.getFilePath((String)type.toLowerCase());
        UploaderVO vo = UploaderVO.builder().name(fileName).build();
        vo.setFileDigest(Md5Util.getMd5((MultipartFile)file));
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)type, (String)fileName, (MultipartFile)file, (String)filePath);
        if (type.equalsIgnoreCase("useravatar")) {
            vo.setUrl(UploaderUtil.uploaderImg((String)fileName));
        } else if (type.equalsIgnoreCase("annex")) {
            vo.setUrl(UploaderUtil.uploaderImg((String)"/api/file/Image/annex/", (String)fileName));
        } else if (type.equalsIgnoreCase("annexpic")) {
            vo.setUrl(UploaderUtil.uploaderImg((String)"/api/file/Image/annex/", (String)fileName));
        } else {
            vo.setUrl(UploaderUtil.uploaderImg((String)("/api/file/Image/" + type.toLowerCase() + "/"), (String)fileName));
        }
        if ("yozo".equals(this.configValueUtil.getAllowPreviewFileType())) {
            try {
                InputStream inputStream = file.getInputStream();
                try {
                    String s = this.yozoUtils.uploadFileInPreview(inputStream, orgFileName);
                    Map map = JsonUtil.stringToMap((String)s);
                    if ("\u64cd\u4f5c\u6210\u529f".equals(map.get("message"))) {
                        Map dataMap = JsonUtil.stringToMap((String)String.valueOf(map.get("data")));
                        String verId = String.valueOf(dataMap.get("fileVersionId"));
                        vo.setFileVersionId(verId);
                    }
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("\u4e0a\u4f20\u5230\u6c38\u4e2d\u5931\u8d25");
                e.printStackTrace();
            }
        }
        String secondFilePath = "";
        UserInfo userInfo = this.userProvider.get();
        FileEntity fe = new FileEntity();
        String fileId = IdWorker.getIdStr();
        fe.setFileId(fileId);
        fe.setUrl(vo.getUrl());
        fe.setFileType(type);
        fe.setSecondFilePath(secondFilePath);
        fe.setEngine(this.configValueUtil.getFileType());
        fe.setBucket(type);
        fe.setCreatorUserId(userInfo.getUserId());
        fe.setFileName(realName);
        fe.setObjName(fileName);
        fe.setSuffix(fileType);
        fe.setSizeInfo(cn.hutool.core.io.FileUtil.readableFileSize((long)file.getSize()));
        fe.setStoragePath(filePath + secondFilePath + fileName);
        fe.setFileDigest(vo.getFileDigest());
        if (ObjectUtil.isNotEmpty((Object)fileType) && UtilsController.isPic(fileType)) {
            try {
                fe.setThumbnail(ImgUtil.toBase64DataUri((Image)ImgUtil.scale((Image)ImgUtil.toImage((byte[])bytes), (int)100, (int)100, null), (String)fileType));
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        this.fileMapper.insert(fe);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploaderVO uploaderVO(MultipartFile file, String type, String modular, String orgFileName) throws IOException {
        String[] arr;
        String fileType = UpUtil.getFileType((MultipartFile)file);
        String fileName = DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + "." + fileType;
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String bucketName = type.toLowerCase();
        String filePath = FilePathUtil.getFilePath((String)bucketName);
        if (StringUtils.isNotEmpty((String)filePath) && (arr = filePath.split("/|\\\\")).length > 0) {
            bucketName = arr[arr.length - 1];
        }
        String secondFilePath = DateUtil.dateNow((String)"yyyy/MM/dd/") + modular + "/";
        UploaderVO vo = UploaderVO.builder().name(fileName).secondFilePath(secondFilePath).build();
        String fileType1 = this.configValueUtil.getFileType();
        vo.setFileDigest(Md5Util.getMd5((MultipartFile)file));
        UploadUtil.uploadFile((String)fileType1, (String)bucketName, (String)fileName, (MultipartFile)file, (String)filePath, (String)secondFilePath);
        String apiUrl = "/api/file/Image/" + type + "/" + secondFilePath;
        vo.setUrl(UploaderUtil.uploaderImg((String)apiUrl, (String)fileName));
        UserInfo userInfo = this.userProvider.get();
        FileEntity fe = new FileEntity();
        String fileId = IdWorker.getIdStr();
        vo.setFileVersionId(fileId);
        fe.setFileId(fileId);
        fe.setUrl(vo.getUrl());
        fe.setFileType(type);
        fe.setSecondFilePath(secondFilePath);
        fe.setEngine(fileType1);
        fe.setBucket(bucketName);
        fe.setCreatorUserId(userInfo.getUserId());
        fe.setFileName(orgFileName);
        fe.setObjName(fileName);
        fe.setSuffix(fileType);
        fe.setSizeInfo(cn.hutool.core.io.FileUtil.readableFileSize((long)file.getSize()));
        fe.setStoragePath(filePath + secondFilePath + "/" + fileName);
        fe.setFileDigest(vo.getFileDigest());
        fe.setModular(modular);
        if (ObjectUtil.isNotEmpty((Object)fileType) && UtilsController.isPic(fileType)) {
            try {
                fe.setThumbnail(ImgUtil.toBase64DataUri((Image)ImgUtil.scale((Image)ImgUtil.toImage((byte[])bytes), (int)100, (int)100, null), (String)fileType));
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        this.fileMapper.insert(fe);
        if ("yozo".equals(this.configValueUtil.getAllowPreviewFileType())) {
            try {
                InputStream inputStream = file.getInputStream();
                try {
                    String s = this.yozoUtils.uploadFileInPreview(inputStream, orgFileName);
                    Map map = JsonUtil.stringToMap((String)s);
                    if ("\u64cd\u4f5c\u6210\u529f".equals(map.get("message"))) {
                        Map dataMap = JsonUtil.stringToMap((String)String.valueOf(map.get("data")));
                        String verId = String.valueOf(dataMap.get("fileVersionId"));
                        vo.setFileVersionId(verId);
                    }
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("\u4e0a\u4f20\u5230\u6c38\u4e2d\u5931\u8d25");
                e.printStackTrace();
            }
        }
        return vo;
    }
}

