/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.utils;

import java.io.File;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipUtils {
    public static void main(String[] args) throws Exception {
    }

    public static void zip(String rootFolder, String zipFileTargetPath) throws Exception {
        ZipUtils.zip(new File(rootFolder), new File(zipFileTargetPath));
    }

    public static void zip(String rootFolder, String zipFileTargetPath, String password, String fileName) throws Exception {
        ZipUtils.zip(new File(rootFolder), new File(zipFileTargetPath), password, fileName);
    }

    public static void zip(File rootFolder, File zipFileTargetPath) throws Exception {
        ZipUtils.verifyZipRootFolder(rootFolder);
        try (ZipFile zipFile = new ZipFile(zipFileTargetPath);){
            for (File f : rootFolder.listFiles()) {
                if (f.isFile()) {
                    zipFile.addFile(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                zipFile.addFolder(f);
            }
        }
    }

    public static void zip(File rootFolder, File zipFileTargetPath, String password, String fileName) throws Exception {
        if (password == null || password.isEmpty()) {
            ZipUtils.zip(rootFolder, zipFileTargetPath);
            return;
        }
        if (!zipFileTargetPath.exists()) {
            zipFileTargetPath.mkdirs();
        }
        ZipUtils.verifyZipRootFolder(rootFolder);
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        try (ZipFile zipFile = new ZipFile(fileName, password.toCharArray());){
            for (File f : rootFolder.listFiles()) {
                if (f.isFile()) {
                    zipFile.addFile(f, zipParameters);
                    continue;
                }
                if (!f.isDirectory()) continue;
                zipFile.addFolder(f, zipParameters);
            }
        }
    }

    public static void zipProjectFiles(String rootFolder, String zipFileTargetPath, String password, String fileName) {
        try {
            ZipUtils.zipProjectFiles(new File(rootFolder), new File(zipFileTargetPath), password, fileName);
        }
        catch (Exception e) {
            System.out.println("\u5f85\u538b\u7f29\u6587\u4ef6\u76ee\u5f55:" + rootFolder + "\u4e0d\u5b58\u5728");
        }
    }

    public static void zipProjectFiles(File rootFolder, File zipFileTargetPath, String password, String fileName) throws Exception {
        if (password == null || password.isEmpty()) {
            ZipUtils.zip(rootFolder, zipFileTargetPath);
            return;
        }
        if (!zipFileTargetPath.exists()) {
            zipFileTargetPath.mkdirs();
        }
        ZipUtils.verifyZipRootFolder(rootFolder);
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        try (ZipFile zipFile = new ZipFile(fileName, password.toCharArray());){
            zipFile.addFolder(rootFolder, zipParameters);
        }
    }

    public static void unZip(String zipFilePath, String targetFolder) throws Exception {
        ZipUtils.unZip(new File(zipFilePath), targetFolder);
    }

    public static void unZip(String zipFilePath, String targetFolder, String password) throws Exception {
        ZipUtils.unZip(new File(zipFilePath), targetFolder, password);
    }

    public static void unZip(File zipFilePath, String targetFolder) throws Exception {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            zipFile.extractAll(targetFolder);
        }
    }

    public static void unZip(File zipFilePath, String targetFolder, String password) throws Exception {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password.toCharArray());
            }
            zipFile.extractAll(targetFolder);
        }
    }

    private static void verifyZipRootFolder(File rootFolder) {
        if (!rootFolder.isDirectory()) {
            throw new RuntimeException("\u538b\u7f29\u8def\u5f84\u6839\u76ee\u5f55\u5fc5\u987b\u662f\u6587\u4ef6\u5939");
        }
        if (rootFolder.listFiles() == null) {
            throw new NullPointerException("\u538b\u7f29\u8def\u5f84\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709\u6587\u4ef6");
        }
    }
}

