package com.bringspring.files.controller;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.LanguageVO;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.minio.MinioUploadUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.files.model.*;
import com.bringspring.files.utils.YozoUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.OptimizeUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.*;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.common.constant.CacheConsts.LOGIN_CACHE;
import static com.bringspring.common.constant.CacheConsts.SHORT_CACHE;
import static com.bringspring.common.util.file.StorageType.MINIO;
import static com.bringspring.common.util.file.StorageType.STORAGE;

/**
 * 通用控制器
 *
 * @author RKKJ开发平台组
 * @version V1.2.191207
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Slf4j
@Tag(name = "公共", description = "file")
@RestController
@RequestMapping("/api/file")
public class UtilsController {

    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private YozoUtils yozoUtils;
    @Autowired
    private MinioUploadUtil minioUploadUtil;

    @Autowired
    private FileMapper fileMapper;

    @Autowired
    private FileDownLogService filedownlogService;

    @Autowired
    private BaseDataUtil baseDataUtil;
    /**
     * 根据文件后缀判断是否图片
     *
     * @author xuyuxiang
     * @date 2020/7/6 15:31
     */
    private static boolean isPic(String fileSuffix) {
        fileSuffix = fileSuffix.toLowerCase();
        return ImgUtil.IMAGE_TYPE_GIF.equals(fileSuffix) || ImgUtil.IMAGE_TYPE_JPG.equals(fileSuffix) || ImgUtil.IMAGE_TYPE_JPEG.equals(fileSuffix) || ImgUtil.IMAGE_TYPE_BMP.equals(fileSuffix) || ImgUtil.IMAGE_TYPE_PNG.equals(fileSuffix) || ImgUtil.IMAGE_TYPE_PSD.equals(fileSuffix);
    }

    /**
     * 语言列表
     *
     * @return
     */
    @Operation(summary = "语言列表")
    @GetMapping("/Language")
    public ActionResult<ListVO<LanguageVO>> getList() {
        String dictionaryTypeId = "dc6b2542d94b407cac61ec1d59592901";
        List<DictionaryDataEntity> list = dictionaryDataService.getList(dictionaryTypeId);
        List<LanguageVO> language = JsonUtil.getJsonToList(list, LanguageVO.class);
        ListVO vo = new ListVO();
        vo.setList(language);
        return ActionResult.success(vo);
    }

    /**
     * 图形验证码
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "图形验证码")
    @GetMapping("/ImageCode/{timestamp}")
    public void imageCode(@PathVariable("timestamp") String timestamp) {
        DownUtil.downCode(null);
        cacheUtil.insert(SHORT_CACHE, timestamp, ServletUtils.getSession().getAttribute(CodeUtil.RANDOMCODEKEY), 120);
    }

    /**
     * 上传文件/图片
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "上传文件/图片")
    @PostMapping(value = "/Uploader/{type}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ActionResult uploader(@RequestPart("file") MultipartFile file,
                                 @PathVariable("type") String type) {
        try {
            String fileType = UpUtil.getFileType(file);
            //验证类型
            if (!OptimizeUtil.fileType(configValueUtil.getAllowUploadFileType(), fileType)) {
                return ActionResult.fail(MsgCode.FA017.get());
            }
            UploaderVO vo = uploaderVO(file, type, file.getOriginalFilename());
            return ActionResult.success(vo);
        } catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail("上传文件/图片" + e.getMessage());
        }
    }

    /**
     * 上传文件/图片
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "上传文件/图片")
    @PostMapping(value = "/Uploader/{modular}/{type}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ActionResult uploader(@RequestPart("file") MultipartFile file, @PathVariable("modular") String modular,
                                 @PathVariable("type") String type) {
        try {
            String fileType = UpUtil.getFileType(file);
            //验证类型
            if (!OptimizeUtil.fileType(configValueUtil.getAllowUploadFileType(), fileType)) {
                return ActionResult.fail(MsgCode.FA017.get());
            }
            UploaderVO vo = uploaderVO(file, type, modular, file.getOriginalFilename());
            return ActionResult.success(vo);
        } catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail("上传文件/图片" + e.getMessage());
        }
    }

    /**
     * 获取下载文件链接
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取下载文件链接")
    @GetMapping("/Download/{type}/{fileName}")
    @NotCheckLogin
    public ActionResult<DownloadVO> downloadUrl(@PathVariable("type") String type,
                                                @PathVariable("fileName") String fileName) {
        type = XSSEscape.escape(type);
        fileName = XSSEscape.escape(fileName);
        UserInfo userInfo = userProvider.get();
        if (!configValueUtil.getFileType().equals(STORAGE)) { // 非本地存储
            DownloadVO vo =
                    DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile(userInfo.getUserId() + "#" + fileName + "#" + type)).build();
            return ActionResult.success(vo);
        }
        String filePath = FilePathUtil.getFilePath(type) + fileName;
        if (FileUtil.fileIsFile(filePath)) {
            DownloadVO vo =
                    DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile(userInfo.getId() + "#" + fileName + "#" + type)).build();
            return ActionResult.success(vo);
        }
        return ActionResult.fail(MsgCode.FA018.get());
    }

    /**
     * 获取下载文件链接
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取下载文件链接")
    @GetMapping("/Download/{type}/{year}/{month}/{day}/{modular}/{fileName}")
    public ActionResult<DownloadVO> downloadUrl(@PathVariable("type") String type,
                                                @PathVariable("year") String year,
                                                @PathVariable("month") String month,
                                                @PathVariable("day") String day,
                                                @PathVariable("modular") String modular,
                                                @PathVariable("fileName") String fileName) {
        /**
         * 2.2 后半段目录 /年/月/日/模块/
         */
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        type = XSSEscape.escape(type);
        fileName = XSSEscape.escape(fileName);
        UserInfo userInfo = userProvider.get();
        if (!configValueUtil.getFileType().equals(STORAGE)) { // 非本地存储
            DownloadVO vo =
                    DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile(ServletUtils.getRequest().getHeader("Authorization") + "#" + fileName + "#" + type + "#" + secondFilePath)).build();
            return ActionResult.success(vo);
        }
        String filePath = FilePathUtil.getFilePath(type) + fileName;
        if (FileUtil.fileIsFile(filePath)) {
            DownloadVO vo =
                    DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile(userInfo.getId() + "#" + fileName + "#" + type + "#" + secondFilePath)).build();
            return ActionResult.success(vo);
        }
        return ActionResult.fail(MsgCode.FA018.get());
    }

    /**
     * 下载文件链接
     *
     * @return
     */
    @NoDataSourceBind()
    @NotCheckLogin
    @Operation(summary = "下载文件链接")
    @GetMapping("/Download")
    public void downloadFile() throws DataException {
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String name = request.getParameter("name");
        String fileNameAll = DesUtil.aesDecode(reqJson);
        if (!StringUtils.isEmpty(fileNameAll)) {
            String[] data = fileNameAll.split("#");
            String token = data.length > 0 ? data[0] : "";
            //验证token
//            if (cacheUtil.exists(LOGIN_CACHE, token)) {
            String fileName = data.length > 1 ? data[1] : "";
            String type = data.length > 2 ? data[2] : "";
            String secondFilePath = data.length > 3 ? data[3] : "";

            /**
             *  2.1 通过fileType获取文件保存目录/minio的bucketName
             *  win或Linux本地存储路径
             */
            String bucketName = type.toLowerCase(); // 初始化 minio的bucketName
            String filePath = FilePathUtil.getFilePath(bucketName); // 获取win或Linux本地存储路径
            if (StringUtils.isNotEmpty(filePath)) {
                String[] arr = filePath.split("/|\\\\");
                if (arr.length > 0) {
                    bucketName = arr[arr.length - 1];
                }
            }
            //下载文件
            if (StringUtils.isNotEmpty(secondFilePath)) {
                UploadUtil.downFile(configValueUtil.getFileType(), fileName, bucketName, filePath, secondFilePath, name);

            } else {
                UploadUtil.downFile(configValueUtil.getFileType(), fileName, type, filePath, name);
            }



//            } else {
//                throw new DataException("token验证失败");
//            }
        }
    }

    /**
     * 下载文件链接
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "下载模板文件链接")
    @GetMapping("/DownloadModel")
    public void downloadModel() throws DataException {
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String fileNameAll = DesUtil.aesDecode(reqJson);
        if (!StringUtils.isEmpty(fileNameAll)) {
            String token = fileNameAll.split("#")[0];
            if (cacheUtil.exists(LOGIN_CACHE, token)) {
                String fileName = fileNameAll.split("#")[1];
                String filePath = configValueUtil.getTemplateFilePath();
                //下载文件
                UploadUtil.downFile(configValueUtil.getFileType(), fileName, FileTypeEnum.TEMPLATEFILE, filePath, null);
            }
        }
    }

    /**
     * 删除单个文件
     *
     * @param type     文件类型
     * @param fileName 文件名称
     */
    @NoDataSourceBind()
    @Operation(summary = "删除单个文件")
    @GetMapping("/remove/{type}/{fileName}")
    public ActionResult delete(@PathVariable("type") String type, @PathVariable("fileName") String fileName) {
        String filePath = FilePathUtil.getFilePath(type.toLowerCase());
        if (FileTypeEnum.IM.equalsIgnoreCase(type)) {
            type = "imfile";
        } else if (FileTypeEnum.ANNEX.equalsIgnoreCase(type)) {
            type = FileTypeEnum.ANNEXPIC;
        }
        //下载文件
        UploadUtil.removeFile(configValueUtil.getFileType(), fileName, type.toLowerCase(), filePath);
        return ActionResult.success(MsgCode.SU003.getDesc());
    }

    /**
     * 删除单个文件
     *
     * @param type     文件类型
     * @param year     存储路径：年
     * @param month    存储路径：月
     * @param day      存储路径：日
     * @param modular  存储路径：所属模块
     * @param fileName 文件名称
     */
    @NoDataSourceBind()
    @Operation(summary = "删除单个文件")
    @GetMapping("/remove/{type}/{year}/{month}/{day}/{modular}/{fileName}")
    public ActionResult delete(@PathVariable("type") String type, @PathVariable("year") String year, @PathVariable("month") String month, @PathVariable("day") String day, @PathVariable("modular") String modular, @PathVariable("fileName") String fileName) {
        /**
         *  2.1 通过fileType获取文件保存目录/minio的bucketName
         *  win或Linux本地存储路径
         */
        String bucketName = type.toLowerCase(); // 初始化 minio的bucketName
        String filePath = FilePathUtil.getFilePath(bucketName); // 获取win或Linux本地存储路径
        if (StringUtils.isNotEmpty(filePath)) {
            String[] arr = filePath.split("/|\\\\");
            if (arr.length > 0) {
                bucketName = arr[arr.length - 1];
            }
        }
        /**
         * 2.2 后半段目录 /年/月/日/模块/
         */
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        //下载文件
        UploadUtil.removeFile(configValueUtil.getFileType(), fileName, bucketName, filePath, secondFilePath);
        return ActionResult.success(MsgCode.SU003.getDesc());
    }

    /**
     * 获取图片
     *
     * @param fileName
     * @param type
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取图片")
    @GetMapping("/Image/{type}/{fileName}")
    public void downLoadImg(@PathVariable("type") String type, @PathVariable("fileName") String fileName) {
        String filePath = FilePathUtil.getFilePath(type.toLowerCase());
        if (FileTypeEnum.IM.equalsIgnoreCase(type)) {
            type = "imfile";
        } else if (FileTypeEnum.ANNEX.equalsIgnoreCase(type)) {
            type = FileTypeEnum.ANNEXPIC;
        }
        //下载文件
        UploadUtil.writeImage(configValueUtil.getFileType(), fileName, type.toLowerCase(), filePath);
    }

    /**
     * 获取图片
     *
     * @param fileName
     * @param type
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取图片")
    @GetMapping("/Image/{type}/{year}/{month}/{day}/{modular}/{fileName}")
    @HandleLog(moduleName = "文件管理", requestMethod = "获取图片")
    public void downLoadImg(@PathVariable("type") String type, @PathVariable("year") String year, @PathVariable(
            "month") String month, @PathVariable("day") String day, @PathVariable("modular") String modular,
                            @PathVariable("fileName") String fileName) {
        /**
         *  2.1 通过fileType获取文件保存目录/minio的bucketName
         *  win或Linux本地存储路径
         */
        String bucketName = type.toLowerCase(); // 初始化 minio的bucketName
        String filePath = FilePathUtil.getFilePath(bucketName); // 获取win或Linux本地存储路径
        if (StringUtils.isNotEmpty(filePath)) {
            String[] arr = filePath.split("/|\\\\");
            if (arr.length > 0) {
                bucketName = arr[arr.length - 1];
            }
        }
        /**
         * 2.2 后半段目录 /年/月/日/模块/
         */
        String secondFilePath = year + "/" + month + "/" + day + "/" + modular + "/";
        //下载文件
        UploadUtil.writeImage(configValueUtil.getFileType(), fileName, bucketName, filePath, secondFilePath);
    }

    /**
     * 获取IM聊天图片
     * 注意 后缀名前端故意把 .替换@
     *
     * @param fileName
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取IM聊天图片")
    @GetMapping("/IMImage/{fileName}")
    public void imImage(@PathVariable("fileName") String fileName) {
        //下载文件
        UploadUtil.downFile(configValueUtil.getFileType(), fileName, "imfile",
                FilePathUtil.getFilePath(FileTypeEnum.IM) + fileName, null);
    }

    /**
     * 查看图片
     *
     * @param type     哪个文件夹
     * @param fileName 文件名称
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "查看图片")
    @GetMapping("/{type}/{fileName}")
    public void img(@PathVariable("type") String type, @PathVariable("fileName") String fileName) {
        String filePath = configValueUtil.getBiVisualPath() + type + File.separator;
        if (MINIO.equals(configValueUtil.getFileType())) {
            fileName = "/" + type + "/" + fileName;
            filePath = configValueUtil.getBiVisualPath().substring(0, configValueUtil.getBiVisualPath().length() - 1);
        }
        //下载文件
        UploadUtil.downFile(configValueUtil.getFileType(), fileName, FileTypeEnum.BIVISUALPATH, filePath, null);
    }

    /**
     * 获取IM聊天语音
     * 注意 后缀名前端故意把 .替换@
     *
     * @param fileName
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取IM聊天语音")
    @GetMapping("/IMVoice/{fileName}")
    public void imVoice(@PathVariable("fileName") String fileName) {
        String paths = FilePathUtil.getFilePath(FileTypeEnum.IM) + fileName.replaceAll("@", ".");
        UploadUtil.downFile(configValueUtil.getFileType(), fileName, "imfile", paths, null);
    }

    /**
     * app启动获取信息
     *
     * @param appName
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "app启动获取信息")
    @GetMapping("/AppStartInfo/{appName}")
    public ActionResult getAppStartInfo(@PathVariable("appName") String appName) {
        appName = XSSEscape.escape(appName);
        JSONObject object = new JSONObject();
        object.put("AppVersion", configValueUtil.getAppVersion());
        object.put("AppUpdateContent", configValueUtil.getAppUpdateContent());
        return ActionResult.success(object);
    }

    //----------------------

    //----------大屏图片下载---------
    @NoDataSourceBind()
    @Operation(summary = "获取图片")
    @GetMapping("/VisusalImg/{type}/{fileName}")
    public void downVisusalImg(@PathVariable("type") String type, @PathVariable("fileName") String fileName) {
        type = XSSEscape.escape(type);
        fileName = XSSEscape.escape(fileName);
        String filePath = FilePathUtil.getFilePath(FileTypeEnum.BIVISUALPATH) + type + File.separator;
        if (MINIO.equals(configValueUtil.getFileType())) {
            fileName = "/" + type + "/" + fileName;
        }
        UploadUtil.downFile(configValueUtil.getFileType(), fileName, FileTypeEnum.BIVISUALPATH, filePath, null);
    }

    @NoDataSourceBind()
    @Operation(summary = "预览文件")
    @GetMapping("/Uploader/Preview")
    @HandleLog(moduleName = "文件管理", requestMethod = "预览文件")
    public ActionResult Preview(PreviewParams previewParams) {
        //读取允许文件预览类型
        String allowPreviewType = configValueUtil.getAllowPreviewFileType();
        String[] fileType = allowPreviewType.split(",");

        String fileName = XSSEscape.escape(previewParams.getFileName());

        //文件预览类型检验
        String docType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String s = Arrays.asList(fileType).stream().filter(type -> type.equals(docType)).findFirst().orElse(null);

        if (StringUtils.isEmpty(s)) {
            return ActionResult.fail("预览失败,请检查文件类型是否规范");
        }

        //解析文件url 获取类型
        String type = FileTypeEnum.ANNEX;

        String secondFilePath = StringUtils.isNotEmpty(previewParams.getSecondFilePath()) ?
                previewParams.getSecondFilePath() : "";
        String fileNameAll = previewParams.getFileDownloadUrl();
        if (!StringUtils.isEmpty(fileNameAll)) {
            String[] data = fileNameAll.split("/");
            type = data.length > 4 ? data[4] : "";
        }

        String url;
        //文件预览策略
        if ("yozo".equals(configValueUtil.getPreviewType())) {
            if (StringUtils.isEmpty(previewParams.getFileVersionId())) {
                return ActionResult.fail("预览失败,请重新上传文件");
            }

            String fileVersionId = XSSEscape.escape(previewParams.getFileVersionId());

            //获取签名
            Map<String, String[]> parameter = new HashMap<String, String[]>();
            parameter.put("appId", new String[]{YozoParams.APP_ID});
            parameter.put("fileVersionId", new String[]{fileVersionId});
            String sign = yozoUtils.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, parameter).getData();
            url = "http://eic.yozocloud.cn/api/view/file?fileVersionId=" + fileVersionId + "&appId=" + YozoParams.APP_ID + "&sign=" + sign;
        } else {
            if ("local".equals(configValueUtil.getFileType())) {
                url = YozoParams.DOMAINS + "/api/file/filedownload/" + type + "/" + secondFilePath + previewParams.getFileName();
            } else {
                url = minioUploadUtil.getFile(secondFilePath + fileName, type);
            }
            //encode编码
            String fileUrl = Base64.encodeBase64String(url.getBytes());
            url = configValueUtil.getKkFileUrl() + "onlinePreview?url=" + fileUrl;
        }
        return ActionResult.success(MsgCode.SU000.get(), url);
    }

    @NoDataSourceBind()
    @Operation(summary = "预转码URL")
    @GetMapping("/Uploader/getPreviewFileTaskUrl")
    @HandleLog(moduleName = "文件管理", requestMethod = "预览文件")
    public ActionResult getPreviewFileTaskUrl() {
        String url = configValueUtil.getKkFileUrl() + "addTask";
        return ActionResult.success(MsgCode.SU000.get(), url);
    }

    @NotCheckLogin
    @NoDataSourceBind()
    @Operation(summary = "kk本地文件预览")
    @GetMapping("/filedownload/{type}/{fileName}")
    @HandleLog(moduleName = "文件管理", requestMethod = "kk本地文件预览")
    public void filedownload(@PathVariable("type") String type, @PathVariable("fileName") String fileName,
                             HttpServletResponse response) {
        String filePath = FilePathUtil.getFilePath(type) + fileName;
        OutputStream os = null;
        if ("local".equals(configValueUtil.getFileType())) {
            //本地取对应文件
            File file = new File(filePath);
            try {
                os = response.getOutputStream();
                String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath()));
                response.setHeader("Content-Type", contentType);
                response.setHeader("Content-Dispostion", "attachment;filename=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
                FileInputStream fileInputStream = new FileInputStream(file);

                WritableByteChannel writableByteChannel = Channels.newChannel(os);

                FileChannel channel = fileInputStream.getChannel();
                channel.transferTo(0, channel.size(), writableByteChannel);
                channel.close();
                os.flush();
                writableByteChannel.close();
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NotCheckLogin
    @NoDataSourceBind()
    @Operation(summary = "kk本地文件预览")
    @GetMapping("/filedownload/{type}/**")
    @HandleLog(moduleName = "文件管理", requestMethod = "文件下载")
    public void filedownload(@PathVariable("type") String type,
                             HttpServletRequest request, HttpServletResponse response) {
        // 获取完整的路径
        String uri = (String) request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        // 获取映射的路径
        String pattern = (String) request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        // 截取带“/”的参数
        String fileName = new AntPathMatcher().extractPathWithinPattern(pattern, uri);

        String filePath = FilePathUtil.getFilePath(type) + fileName;
        OutputStream os = null;
        if ("local".equals(configValueUtil.getFileType())) {
            //本地取对应文件
            File file = new File(filePath);
            try {
                os = response.getOutputStream();
                String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath()));
                response.setHeader("Content-Type", contentType);
                response.setHeader("Content-Dispostion", "attachment;filename=" + new String(file.getName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
                FileInputStream fileInputStream = new FileInputStream(file);

                WritableByteChannel writableByteChannel = Channels.newChannel(os);

                FileChannel channel = fileInputStream.getChannel();
                channel.transferTo(0, channel.size(), writableByteChannel);
                channel.close();
                os.flush();
                writableByteChannel.close();
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @NoDataSourceBind()
    @Operation(summary = "分片上传获取")


    @GetMapping("/chunk")
    public ActionResult checkChunk(Chunk chunk) {
        String type = chunk.getExtension();
        if (!OptimizeUtil.fileType(configValueUtil.getAllowUploadFileType(), type)) {
            return ActionResult.fail(MsgCode.FA017.get());
        }
        String identifier = chunk.getIdentifier();
        String path = FilePathUtil.getFilePath(FileTypeEnum.TEMPORARY);
        String filePath = XSSEscape.escapePath(path + identifier);
        List<File> chunkFiles = FileUtil.getFile(new File(filePath));
        log.info("分片上传是否有缓存：", chunkFiles);
        List<Integer> existsChunk = chunkFiles.stream().filter(f -> {
            if (f.getName().endsWith(".tmp")) {
                FileUtils.deleteQuietly(f);
                return false;
            } else {
                return true;
            }
        }).map(f -> Integer.parseInt(f.getName().replace(chunk.getIdentifier().concat("-"), ""))).collect(Collectors.toList());
        //分片数量和已上传数量如果一致就执行合并
        boolean mergeFlag = existsChunk.size() == chunk.getTotalChunks();
        ChunkRes chunkRes = ChunkRes.builder().merge(mergeFlag).chunkNumbers(existsChunk).build();
        //
        return ActionResult.success(chunkRes);
    }

    @NoDataSourceBind()
    @Operation(summary = "分片上传附件")
    @PostMapping("/chunk")
    public ActionResult upload(Chunk chunk, @RequestParam("file") MultipartFile file) {
        String type = chunk.getExtension();
        if (!OptimizeUtil.fileType(configValueUtil.getAllowUploadFileType(), type)) {
            return ActionResult.fail(MsgCode.FA017.get());
        }
        ChunkRes chunkRes = ChunkRes.builder().build();
        chunkRes.setMerge(false);
        File chunkFile = null;
        File chunkTmpFile = null;
        try {
            String filePath = FilePathUtil.getFilePath(FileTypeEnum.TEMPORARY);
            Integer chunkNumber = chunk.getChunkNumber();
            String identifier = chunk.getIdentifier();
            String chunkTempPath = filePath + identifier;
            File path = new File(chunkTempPath);
            if (!path.exists()) {
                path.mkdirs();
            }
            String chunkName = identifier.concat("-") + chunkNumber;
            String chunkTmpName = chunkName.concat(".tmp");
            chunkFile = new File(chunkTempPath, chunkName);
            chunkTmpFile = new File(chunkTempPath, chunkTmpName);
            if (chunkFile.exists() && chunkFile.length() == chunk.getCurrentChunkSize()) {
                System.out.println("该分块已经上传：" + chunkFile.getName());
            } else {
                @Cleanup InputStream inputStream = file.getInputStream();
                FileUtils.copyInputStreamToFile(inputStream, chunkTmpFile);
                chunkTmpFile.renameTo(chunkFile);
            }
            log.info("分片上传最后看是否merge：" + chunk.getChunkNumber(), chunk.getTotalChunks());
            chunkRes.setMerge(chunk.getChunkNumber().equals(chunk.getTotalChunks()));
        } catch (Exception e) {
            try {
                FileUtils.deleteQuietly(chunkTmpFile);
                FileUtils.deleteQuietly(chunkFile);
            } catch (Exception ee) {
                e.printStackTrace();
            }
            return ActionResult.fail("上传异常");
        }
        return ActionResult.success(chunkRes);
    }

    @NoDataSourceBind()
    @Operation(summary = "分片组装")
    @PostMapping("/merge")
    public ActionResult merge(MergeChunkDto mergeChunkDto) {
        String identifier = mergeChunkDto.getIdentifier();
        String path = FilePathUtil.getFilePath(FileTypeEnum.TEMPORARY);
        String filePath = XSSEscape.escapePath(path + identifier);
        String uuid = RandomUtil.uuId();
        String partFile = XSSEscape.escapePath(path + uuid + "." + mergeChunkDto.getExtension());
        UploaderVO vo = UploaderVO.builder().build();
        try {
            List<File> mergeFileList = FileUtil.getFile(new File(filePath));
            @Cleanup FileOutputStream destTempfos = new FileOutputStream(partFile, true);
            for (int i = 0; i < mergeFileList.size(); i++) {
                String chunkName = identifier.concat("-") + (i + 1);
                File files = new File(filePath, chunkName);
                if (files.exists()) {
                    FileUtils.copyFile(files, destTempfos);
                }
            }
            File partFiles = new File(partFile);
            if (partFiles.exists()) {
                MultipartFile multipartFile = FileUtil.createFileItem(partFiles);
                String type = mergeChunkDto.getType();
//                vo = uploaderVO(multipartFile, type);
                String modular = mergeChunkDto.getModular();
                if (StringUtils.isNotEmpty(modular)) {
                    vo = uploaderVO(multipartFile, type, modular, mergeChunkDto.getFileName());
                } else {
                    vo = uploaderVO(multipartFile, type, mergeChunkDto.getFileName());
                }
                FileUtil.deleteTmp(multipartFile);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("合并分片失败:" + e);
        } finally {
            FileUtils.deleteQuietly(new File(filePath));
            FileUtils.deleteQuietly(new File(partFile));
        }
        vo.setFileSize(mergeChunkDto.getFileSize());
        vo.setSecondFilePath(vo.getSecondFilePath());
        return ActionResult.success(vo);
    }

    /**
     * 封装上传附件
     *
     * @param file
     * @param type
     * @return
     * @throws IOException
     */
    private UploaderVO uploaderVO(MultipartFile file, String type, String realName) throws IOException {
        String orgFileName = file.getOriginalFilename();
        String fileType = UpUtil.getFileType(file);
//        if (OptimizeUtil.fileSize(file.getSize(), 1024000)) {
//            return ActionResult.fail("上传失败，文件大小超过1M");
//        }
        String fileName = DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + "." + fileType;
        if (type.equals(FileTypeEnum.MAIL)) {
            type = FileTypeEnum.TEMPORARY;
        }
        String filePath = FilePathUtil.getFilePath(type.toLowerCase());
        UploaderVO vo = UploaderVO.builder().name(fileName).build();
        vo.setFileDigest(Md5Util.getMd5(file));
        /*
         * 生成缩略图使用
         * */
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        } catch (Exception ignored) {
        }
        //上传文件
        UploadUtil.uploadFile(configValueUtil.getFileType(), type, fileName, file, filePath);
        if (type.equalsIgnoreCase(FileTypeEnum.USERAVATAR)) {
            vo.setUrl(UploaderUtil.uploaderImg(fileName));
        } else if (type.equalsIgnoreCase(FileTypeEnum.ANNEX)) {
//            UserInfo userInfo = userProvider.get();
//            vo.setUrl(UploaderUtil.uploaderFile(userInfo.getId() + "#" + fileName + "#" + type));
            vo.setUrl(UploaderUtil.uploaderImg("/api/file/Image/annex/", fileName));
        } else if (type.equalsIgnoreCase(FileTypeEnum.ANNEXPIC)) {
            vo.setUrl(UploaderUtil.uploaderImg("/api/file/Image/annex/", fileName));
        } else {
            vo.setUrl(UploaderUtil.uploaderImg("/api/file/Image/" + type.toLowerCase() + "/", fileName));
        }

        //上传到永中
        if ("yozo".equals(configValueUtil.getAllowPreviewFileType())) {
            try {
                @Cleanup InputStream inputStream = file.getInputStream();
                String s = yozoUtils.uploadFileInPreview(inputStream, orgFileName);
                Map<String, Object> map = JsonUtil.stringToMap(s);
                if ("操作成功".equals(map.get("message"))) {
                    Map<String, Object> dataMap = JsonUtil.stringToMap(String.valueOf(map.get("data")));
                    String verId = String.valueOf(dataMap.get("fileVersionId"));
                    vo.setFileVersionId(verId);
                }
            } catch (Exception e) {
                System.out.println("上传到永中失败");
                e.printStackTrace();
            }
        }

        String secondFilePath = "";
        UserInfo userInfo = userProvider.get();
        // 将文件信息保存到数据库
        FileEntity fe = new FileEntity();
        // 生成id
        String fileId = IdWorker.getIdStr();
        fe.setFileId(fileId);
        fe.setUrl(vo.getUrl());
        fe.setFileType(type);
        fe.setSecondFilePath(secondFilePath);
        fe.setEngine(configValueUtil.getFileType());
        fe.setBucket(type);
        fe.setCreatorUserId(userInfo.getUserId());
        fe.setFileName(realName);
        fe.setObjName(fileName);
        fe.setSuffix(fileType);
        fe.setSizeInfo(cn.hutool.core.io.FileUtil.readableFileSize(file.getSize()));
        // 存储路径
        fe.setStoragePath(filePath + secondFilePath + fileName);
        fe.setFileDigest(vo.getFileDigest());
        // 如果是图片，则压缩生成缩略图
        if (ObjectUtil.isNotEmpty(fileType)) {
            if (isPic(fileType)) {
                try {
                    fe.setThumbnail(ImgUtil.toBase64DataUri(ImgUtil.scale(ImgUtil.toImage(bytes),
                            100, 100, null), fileType));
                } catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }

        fileMapper.insert(fe);
        return vo;
    }

    /**
     * 封装上传附件
     *
     * @param file
     * @param type    文件类型
     * @param modular 所属模块
     * @return
     * @throws IOException
     */
    private UploaderVO uploaderVO(MultipartFile file, String type, String modular, String orgFileName) throws IOException {

        // 文件后缀名
        String fileType = UpUtil.getFileType(file);
//        if (OptimizeUtil.fileSize(file.getSize(), 1024000)) {
//            return ActionResult.fail("上传失败，文件大小超过1M");
//        }
        /**
         * 1 文件重命名
         */
        String fileName = DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + "." + fileType;


        /*
         * 生成缩略图使用
         * */
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        } catch (Exception ignored) {
        }

        /**
         *  2.1 通过fileType获取文件保存目录/minio的bucketName
         *  win或Linux本地存储路径
         */
        String bucketName = type.toLowerCase(); // 初始化 minio的bucketName
        String filePath = FilePathUtil.getFilePath(bucketName); // 获取win或Linux本地存储路径
        if (StringUtils.isNotEmpty(filePath)) {
            String[] arr = filePath.split("/|\\\\");
            if (arr.length > 0) {
                bucketName = arr[arr.length - 1];
            }
        }

        /**
         * 2.2 后半段目录 /年/月/日/模块/
         */
        String secondFilePath = DateUtil.dateNow("yyyy/MM/dd/") + modular + "/";
        UploaderVO vo = UploaderVO.builder().name(fileName).secondFilePath(secondFilePath).build();
        // 文件存储类型(local-本地存储，minio-网络存储)
        String fileType1 = configValueUtil.getFileType();
        vo.setFileDigest(Md5Util.getMd5(file));
        //上传文件

        UploadUtil.uploadFile(fileType1, bucketName, fileName, file, filePath, secondFilePath);

        String apiUrl = "/api/file/Image/" + type + "/" + secondFilePath;
        vo.setUrl(UploaderUtil.uploaderImg(apiUrl, fileName));

        UserInfo userInfo = userProvider.get();

        // 将文件信息保存到数据库
        FileEntity fe = new FileEntity();
        // 生成id
        String fileId = IdWorker.getIdStr();
        vo.setFileVersionId(fileId);
        fe.setFileId(fileId);
        fe.setUrl(vo.getUrl());
        fe.setFileType(type);
        fe.setSecondFilePath(secondFilePath);
        fe.setEngine(fileType1);
        fe.setBucket(bucketName);
        fe.setCreatorUserId(userInfo.getUserId());
        fe.setFileName(orgFileName);
        fe.setObjName(fileName);
        fe.setSuffix(fileType);
        fe.setSizeInfo(cn.hutool.core.io.FileUtil.readableFileSize(file.getSize()));
        // 存储路径
        fe.setStoragePath(filePath + secondFilePath + StrUtil.SLASH + fileName);
        fe.setFileDigest(vo.getFileDigest());
        fe.setModular(modular);
        // 如果是图片，则压缩生成缩略图
        if (ObjectUtil.isNotEmpty(fileType)) {
            if (isPic(fileType)) {
                try {
                    fe.setThumbnail(ImgUtil.toBase64DataUri(ImgUtil.scale(ImgUtil.toImage(bytes),
                            100, 100, null), fileType));
                } catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }

        fileMapper.insert(fe);

        //上传到永中
        if ("yozo".equals(configValueUtil.getAllowPreviewFileType())) {
            try {
                @Cleanup InputStream inputStream = file.getInputStream();
                String s = yozoUtils.uploadFileInPreview(inputStream, orgFileName);
                Map<String, Object> map = JsonUtil.stringToMap(s);
                if ("操作成功".equals(map.get("message"))) {
                    Map<String, Object> dataMap = JsonUtil.stringToMap(String.valueOf(map.get("data")));
                    String verId = String.valueOf(dataMap.get("fileVersionId"));
                    vo.setFileVersionId(verId);
                }
            } catch (Exception e) {
                System.out.println("上传到永中失败");
                e.printStackTrace();
            }
        }
        return vo;
    }
}
