/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.param.FilePageParam;
import com.bringspring.files.service.FileService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6587\u4ef6\u7ba1\u7406", description="\u6587\u4ef6\u4e0a\u4f20\u3001\u4e0b\u8f7d\u3001\u5220\u9664\u7b49\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/api/files"})
public class FileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Resource
    private FileService fileService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u5206\u9875\u5217\u8868", description="\u6839\u636e\u5206\u9875\u53c2\u6570\u83b7\u53d6\u6587\u4ef6\u5217\u8868\uff0c\u652f\u6301\u6309\u6761\u4ef6\u7b5b\u9009")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u6210\u529f\u83b7\u53d6\u6587\u4ef6\u5217\u8868"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9519\u8bef"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @GetMapping(value={"/page"})
    public ActionResult page(@Parameter(description="\u6587\u4ef6\u5206\u9875\u67e5\u8be2\u53c2\u6570") FilePageParam filePageParam) {
        List<FileEntity> list = this.fileService.getList(filePageParam);
        for (FileEntity file : list) {
            if (ObjectUtil.isEmpty((Object)file.getCreatorUserId())) continue;
            file.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(file.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)filePageParam), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5220\u9664\u6587\u4ef6", description="\u6279\u91cf\u5220\u9664\u6307\u5b9aID\u7684\u6587\u4ef6")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u6587\u4ef6\u5220\u9664\u6210\u529f"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9519\u8bef\uff0cID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"), @ApiResponse(responseCode="404", description="\u6587\u4ef6\u4e0d\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @PostMapping(value={"/delete"})
    public ActionResult<String> delete(@Parameter(description="\u6587\u4ef6ID\u5217\u8868", required=true) @RequestBody @NotEmpty(message="\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a") List<String> ids) {
        ActionResult res = this.fileService.delete(ids);
        return res;
    }
}

