package com.bringspring.files.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.entity.FileDownLogEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.model.filedownlog.FileDownLogInfoVO;
import com.bringspring.common.model.filedownlog.FileDownLogPagination;
import com.bringspring.common.model.filedownlog.FileDownLogUpForm;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;

/**
 * 文件下载日志
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-03-13
 */
@Slf4j
@RestController
@Tag(name = "文件下载日志", description = "文件下载记录管理")
@RequestMapping("/api/files/FileDownLog")
public class FileDownLogController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private FileDownLogService filedownlogService;


    /**
     * 列表
     *
     * @param filedownlogPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody FileDownLogPagination filedownlogPagination) throws IOException {
        UserInfo userInfo = userProvider.get();
        List<FileDownLogEntity> list = filedownlogService.getList(filedownlogPagination);
        List<FileDownLogCrForm> listVO = JsonUtil.getJsonToList(list, FileDownLogCrForm.class);
        listVO.forEach(v -> v.setCreatorUserName(baseDataUtil.userSelectValue(v.getCreatorUserId())));
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(filedownlogPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param filedownlogCrForm
     * @return
     */
    @PostMapping
    public ActionResult create(@RequestBody @Valid FileDownLogCrForm filedownlogCrForm) throws DataException {
        filedownlogService.create(filedownlogCrForm);
        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<FileDownLogInfoVO> info(@PathVariable("id") String id) {
        FileDownLogEntity entity = filedownlogService.getInfo(id);
        FileDownLogInfoVO vo = JsonUtil.getJsonToBean(entity, FileDownLogInfoVO.class);

        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<FileDownLogInfoVO> detailInfo(@PathVariable("id") String id) {
        FileDownLogEntity entity = filedownlogService.getInfo(id);
        FileDownLogInfoVO vo = JsonUtil.getJsonToBean(entity, FileDownLogInfoVO.class);

        //子表数据转换

        //附表数据转换

//添加到详情表单对象中

        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid FileDownLogUpForm filedownlogUpForm) throws DataException {
        filedownlogService.update(id, filedownlogUpForm);
        return ActionResult.success("更新成功");
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        FileDownLogEntity entity = filedownlogService.getInfo(id);
        if (entity != null) {
            filedownlogService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


}
