/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.utils;

import client.UaaAppAuthenticator;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.files.model.YozoParams;
import constants.EnumResultCode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import utils.DefaultResult;
import utils.IResult;

@Component
public class YozoUtils {
    public IResult<String> generateSign(String appId, String secret, Map<String, String[]> params) {
        UaaAppAuthenticator authenticator = new UaaAppAuthenticator("sign", null, "appId");
        try {
            String[] appIds = params.get("appId");
            if (appIds == null || appIds.length != 1 || StringUtils.isEmpty((Object)appIds[0])) {
                params.put("appId", new String[]{appId});
            }
            String sign = authenticator.generateSign(secret, params);
            return DefaultResult.successResult((Object)sign);
        }
        catch (Exception e) {
            return DefaultResult.failResult((String)EnumResultCode.E_GENERATE_SIGN_FAIL.getInfo());
        }
    }

    public String getFileName(String fileName, String templateType) {
        String suffix = switch (templateType) {
            case "1" -> ".doc";
            case "2" -> ".docx";
            case "3" -> ".ppt";
            case "4" -> ".pptx";
            case "5" -> ".xls";
            case "6" -> ".xlsx";
            default -> null;
        };
        if (suffix == null) {
            return null;
        }
        String name = fileName + suffix;
        return name;
    }

    public String uploadFile(String url, File file, String appId, String sign) {
        String result = "";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            try {
                String fileName = file.getName();
                FileBody fileBody = new FileBody(file, ContentType.MULTIPART_FORM_DATA, fileName);
                HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody).addPart("appId", (ContentBody)new StringBody(appId, ContentType.TEXT_PLAIN)).addPart("sign", (ContentBody)new StringBody(sign, ContentType.TEXT_PLAIN)).build();
                httpPost.setEntity(httpEntity);
                try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);){
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String fileUrl, String savePath) throws Exception {
        File file = new File(XSSEscape.escapePath((String)savePath));
        if (!file.exists()) {
            file.createNewFile();
        }
        URL url = new URL(fileUrl);
        HttpURLConnection urlCon = (HttpURLConnection)url.openConnection();
        urlCon.setConnectTimeout(6000);
        urlCon.setReadTimeout(6000);
        int code = urlCon.getResponseCode();
        if (code != 200) {
            throw new Exception("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        DataInputStream in = new DataInputStream(urlCon.getInputStream());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(savePath);
            try {
                DataOutputStream out = new DataOutputStream(fileOutputStream);
                try {
                    byte[] buffer = new byte[2048];
                    int count = 0;
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                    try {
                        out.close();
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (Collections.singletonList(out).get(0) != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(fileOutputStream).get(0) != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFileInPreview(InputStream inputStream, String fileName) throws IOException {
        HashMap<String, String[]> parameter = new HashMap<String, String[]>();
        parameter.put("appId", new String[]{YozoParams.APP_ID});
        String sign = (String)this.generateSign(YozoParams.APP_ID, YozoParams.APP_KEY, parameter).getData();
        String url = "http://dmc.yozocloud.cn/api/file/upload?appId=" + YozoParams.APP_ID + "&sign=" + sign;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String result = "";
            HttpEntity httpEntity = null;
            HttpEntity responseEntity = null;
            try {
                HttpPost httpPost = new HttpPost(url);
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
                multipartEntityBuilder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, fileName);
                httpEntity = multipartEntityBuilder.build();
                httpPost.setEntity(httpEntity);
                try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);){
                    responseEntity = response.getEntity();
                    result = EntityUtils.toString((HttpEntity)responseEntity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            String string = result;
            return string;
        }
    }
}

