/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.meetingroom.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.meetingroom.entity.OtMeetingRoomEntity;
import com.bringspring.meetingroom.entity.OtMeetingRoomReservationEntity;
import com.bringspring.meetingroom.model.otmeetingroom.OtMeetingRoomModel;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationCrForm;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationInfoVO;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationListVO;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationPagination;
import com.bringspring.meetingroom.model.otmeetingroomreservation.OtMeetingRoomReservationUpForm;
import com.bringspring.meetingroom.service.OtMeetingRoomReservationService;
import com.bringspring.meetingroom.service.OtMeetingRoomService;
import com.bringspring.meetingroom.utils.MeetingConstants;
import com.bringspring.visualdev.base.util.GeneraterSwapUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f1a\u8bae\u5ba4\u9884\u5b9a\u4fe1\u606f"}, value="OtMeetingRoom")
@RequestMapping(value={"/api/OtMeetingRoom/OtMeetingRoomReservation"})
public class OtMeetingRoomReservationController {
    private static final Logger log = LoggerFactory.getLogger(OtMeetingRoomReservationController.class);
    @Autowired
    private GeneraterSwapUtil generaterSwapUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OtMeetingRoomReservationService otMeetingRoomReservationService;
    @Autowired
    private OtMeetingRoomService otMeetingRoomService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        List<String> myselfMeetingList;
        List<String> regularMeetingByTime;
        ArrayList<String> idsList = new ArrayList<String>();
        if (StringUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped()) && StringUtil.isNotEmpty(regularMeetingByTime = this.otMeetingRoomReservationService.getRegularMeetingByTime(otMeetingRoomReservationPagination.getAllDateScoped()))) {
            idsList.addAll(regularMeetingByTime);
        }
        if ("2".equals(otMeetingRoomReservationPagination.getShowMeetingType()) && StringUtil.isNotEmpty(myselfMeetingList = this.otMeetingRoomReservationService.getMyselfMeetingList())) {
            idsList.addAll(myselfMeetingList);
        }
        otMeetingRoomReservationPagination.setRegularMeetingIdList(idsList);
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : list) {
            otMeetingRoomReservationEntity.setMeetingType(this.generaterSwapUtil.getDicName(otMeetingRoomReservationEntity.getMeetingType(), "442613235368067077"));
            otMeetingRoomReservationEntity.setHostingUserId(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getHostingUserId()));
            otMeetingRoomReservationEntity.setHostingDepartment(this.generaterSwapUtil.comSelectValues(otMeetingRoomReservationEntity.getHostingDepartment()));
            otMeetingRoomReservationEntity.setContactsUserId(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getContactsUserId()));
            otMeetingRoomReservationEntity.setParticipantsUserIds(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getParticipantsUserIds()));
            otMeetingRoomReservationEntity.setMeetingMinutesOfficer(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getMeetingMinutesOfficer()));
            otMeetingRoomReservationEntity.setRepetitiveMode(this.generaterSwapUtil.getDicName(otMeetingRoomReservationEntity.getRepetitiveMode(), "442613995455643653"));
            otMeetingRoomReservationEntity.setResourcePreparation(this.generaterSwapUtil.getDicName(otMeetingRoomReservationEntity.getResourcePreparation(), "442951278029438981"));
            otMeetingRoomReservationEntity.setFilesPath(this.generaterSwapUtil.getFileNameInJson(otMeetingRoomReservationEntity.getFilesPath()));
            otMeetingRoomReservationEntity.setCreatorUserId(this.generaterSwapUtil.userSelectValue(otMeetingRoomReservationEntity.getCreatorUserId()));
            otMeetingRoomReservationEntity.setLastModifyUserId(this.generaterSwapUtil.userSelectValue(otMeetingRoomReservationEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        for (OtMeetingRoomReservationListVO roomReservationListVO : listVO) {
            if (StringUtil.isNotEmpty((String)roomReservationListVO.getMeetingRoomId())) {
                QueryWrapper queryWrapperOtMeetingRoom = new QueryWrapper();
                queryWrapperOtMeetingRoom.lambda().eq(OtMeetingRoomEntity::getId, (Object)roomReservationListVO.getMeetingRoomId());
                OtMeetingRoomEntity meetingRoomEntity = (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapperOtMeetingRoom);
                roomReservationListVO.setMeetingRoomName(meetingRoomEntity.getName());
            }
            roomReservationListVO.setMeetingModeName(this.generaterSwapUtil.getDicName(roomReservationListVO.getMeetingMode(), "442613624519786501"));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getCalendarList"})
    public ActionResult getCalendarList(@RequestBody OtMeetingRoomReservationPagination otMeetingRoomReservationPagination) throws IOException {
        List<String> myselfMeetingList;
        ArrayList<String> idsList = new ArrayList<String>();
        Date fir = new Date();
        Date sec = new Date();
        if (StringUtil.isNotEmpty(otMeetingRoomReservationPagination.getAllDateScoped())) {
            fir = DateUtil.stringToDate((String)otMeetingRoomReservationPagination.getAllDateScoped().get(0));
            sec = DateUtil.stringToDate((String)otMeetingRoomReservationPagination.getAllDateScoped().get(1));
            ArrayList<String> time = new ArrayList<String>();
            time.add(String.valueOf(fir.getTime()));
            time.add(String.valueOf(sec.getTime()));
            List<String> regularMeetingByTime = this.otMeetingRoomReservationService.getRegularMeetingByTime(time);
            if (StringUtil.isNotEmpty(regularMeetingByTime)) {
                idsList.addAll(regularMeetingByTime);
            }
        }
        if ("2".equals(otMeetingRoomReservationPagination.getShowMeetingType()) && StringUtil.isNotEmpty(myselfMeetingList = this.otMeetingRoomReservationService.getMyselfMeetingList())) {
            idsList.addAll(myselfMeetingList);
        }
        otMeetingRoomReservationPagination.setRegularMeetingIdList(idsList);
        List<OtMeetingRoomReservationEntity> list = this.otMeetingRoomReservationService.getList(otMeetingRoomReservationPagination);
        ArrayList<OtMeetingRoomReservationEntity> extreList = new ArrayList<OtMeetingRoomReservationEntity>();
        for (OtMeetingRoomReservationEntity otMeetingRoomReservationEntity : list) {
            List<Date> regularMeetingTimeList;
            otMeetingRoomReservationEntity.setMeetingType(this.generaterSwapUtil.getDicName(otMeetingRoomReservationEntity.getMeetingType(), "442613235368067077"));
            otMeetingRoomReservationEntity.setHostingUserId(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getHostingUserId()));
            otMeetingRoomReservationEntity.setHostingDepartment(this.generaterSwapUtil.comSelectValues(otMeetingRoomReservationEntity.getHostingDepartment()));
            otMeetingRoomReservationEntity.setContactsUserId(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getContactsUserId()));
            otMeetingRoomReservationEntity.setParticipantsUserIds(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getParticipantsUserIds()));
            otMeetingRoomReservationEntity.setMeetingMinutesOfficer(this.generaterSwapUtil.userSelectValues(otMeetingRoomReservationEntity.getMeetingMinutesOfficer()));
            otMeetingRoomReservationEntity.setResourcePreparation(this.generaterSwapUtil.getDicName(otMeetingRoomReservationEntity.getResourcePreparation(), "442951278029438981"));
            otMeetingRoomReservationEntity.setFilesPath(this.generaterSwapUtil.getFileNameInJson(otMeetingRoomReservationEntity.getFilesPath()));
            otMeetingRoomReservationEntity.setCreatorUserId(this.generaterSwapUtil.userSelectValue(otMeetingRoomReservationEntity.getCreatorUserId()));
            otMeetingRoomReservationEntity.setLastModifyUserId(this.generaterSwapUtil.userSelectValue(otMeetingRoomReservationEntity.getLastModifyUserId()));
            if (!otMeetingRoomReservationEntity.getMeetingMode().equals(MeetingConstants.MEETING_MODE) || (regularMeetingTimeList = this.otMeetingRoomReservationService.getRegularMeetingTimeList(otMeetingRoomReservationEntity)).size() <= 0) continue;
            for (Date date : regularMeetingTimeList) {
                OtMeetingRoomReservationEntity reservationEntity = new OtMeetingRoomReservationEntity();
                reservationEntity.setId(otMeetingRoomReservationEntity.getId());
                reservationEntity.setMeetingTitle(otMeetingRoomReservationEntity.getMeetingTitle());
                reservationEntity.setRepetitiveMode(otMeetingRoomReservationEntity.getRepetitiveMode());
                reservationEntity.setEnabledMark(otMeetingRoomReservationEntity.getEnabledMark());
                reservationEntity.setStartTime(DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + otMeetingRoomReservationEntity.getRepetitiveStartTime())));
                reservationEntity.setEndTime(DateUtil.stringToDate((String)(DateUtil.daFormat((Date)date) + " " + otMeetingRoomReservationEntity.getRepetitiveEndTime())));
                if (!reservationEntity.getStartTime().after(fir) || !reservationEntity.getStartTime().before(sec)) continue;
                extreList.add(reservationEntity);
            }
        }
        list.addAll(extreList);
        list.removeIf(i -> StringUtil.isNotEmpty((String)i.getRepetitiveInterval()));
        List listVO = JsonUtil.getJsonToList(list, OtMeetingRoomReservationListVO.class);
        for (OtMeetingRoomReservationListVO roomReservationListVO : listVO) {
            if (StringUtil.isNotEmpty((String)roomReservationListVO.getMeetingRoomId())) {
                QueryWrapper queryWrapperOtMeetingRoom = new QueryWrapper();
                queryWrapperOtMeetingRoom.lambda().eq(OtMeetingRoomEntity::getId, (Object)roomReservationListVO.getMeetingRoomId());
                OtMeetingRoomEntity meetingRoomEntity = (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapperOtMeetingRoom);
                roomReservationListVO.setMeetingRoomName(meetingRoomEntity.getName());
            }
            roomReservationListVO.setMeetingModeName(this.generaterSwapUtil.getDicName(roomReservationListVO.getMeetingMode(), "442613624519786501"));
        }
        ArrayList arrayList = listVO.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OtMeetingRoomReservationListVO>(Comparator.comparing(OtMeetingRoomReservationListVO::getStartTime))), ArrayList::new));
        PageListVO vo = new PageListVO();
        vo.setList((List)arrayList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)otMeetingRoomReservationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OtMeetingRoomReservationCrForm otMeetingRoomReservationCrForm) throws DataException {
        Boolean flag;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        otMeetingRoomReservationCrForm.setCreatorUserId(userInfo.getUserId());
        otMeetingRoomReservationCrForm.setCreatorTime(DateUtil.getNow());
        if ("temporary".equals(otMeetingRoomReservationCrForm.getButtonFlag())) {
            otMeetingRoomReservationCrForm.setEnabledMark("10");
        } else {
            otMeetingRoomReservationCrForm.setEnabledMark("20");
        }
        OtMeetingRoomReservationEntity entity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationCrForm, OtMeetingRoomReservationEntity.class);
        if (MeetingConstants.MEETING_MODE.equals(entity.getMeetingMode()) ? (flag = this.otMeetingRoomReservationService.judgeRegularTimeConflict(entity)) != false : (flag = this.otMeetingRoomReservationService.judgeOriginaryTimeConflict(entity)) != false) {
            return ActionResult.success((String)MeetingConstants.DUPLICATION);
        }
        entity.setId(mainId);
        this.otMeetingRoomReservationService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f\uff01");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OtMeetingRoomReservationInfoVO> info(@PathVariable(value="id") String id) {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        OtMeetingRoomReservationInfoVO vo = (OtMeetingRoomReservationInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationInfoVO.class);
        vo.setCreatorUserId(this.generaterSwapUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.generaterSwapUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        QueryWrapper queryWrapperOtMeetingRoom = new QueryWrapper();
        queryWrapperOtMeetingRoom.lambda().eq(OtMeetingRoomEntity::getId, (Object)entity.getMeetingRoomId());
        OtMeetingRoomEntity meetingRoomEntity = (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapperOtMeetingRoom);
        vo.setOt_meeting_room((OtMeetingRoomModel)JsonUtil.getJsonToBean((Object)meetingRoomEntity, OtMeetingRoomModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OtMeetingRoomReservationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        OtMeetingRoomReservationInfoVO vo = (OtMeetingRoomReservationInfoVO)JsonUtil.getJsonToBean((Object)entity, OtMeetingRoomReservationInfoVO.class);
        QueryWrapper queryWrapperOtMeetingRoom = new QueryWrapper();
        queryWrapperOtMeetingRoom.lambda().eq(OtMeetingRoomEntity::getId, (Object)entity.getMeetingRoomId());
        OtMeetingRoomEntity meetingRoomEntity = (OtMeetingRoomEntity)this.otMeetingRoomService.getOne((Wrapper)queryWrapperOtMeetingRoom);
        if (ObjectUtil.isEmpty((Object)meetingRoomEntity)) {
            meetingRoomEntity = new OtMeetingRoomEntity();
        }
        vo.setOt_meeting_room((OtMeetingRoomModel)JsonUtil.getJsonToBean((Object)meetingRoomEntity, OtMeetingRoomModel.class));
        vo.setMeetingType(this.generaterSwapUtil.getDicName(vo.getMeetingType(), "442613235368067077"));
        vo.setHostingUserId(this.generaterSwapUtil.userSelectValues(vo.getHostingUserId()));
        vo.setHostingDepartment(this.generaterSwapUtil.comSelectValues(vo.getHostingDepartment()));
        vo.setContactsUserId(this.generaterSwapUtil.userSelectValues(vo.getContactsUserId()));
        vo.setParticipantsUserIds(this.generaterSwapUtil.userSelectValues(vo.getParticipantsUserIds()));
        vo.setMeetingMinutesOfficer(this.generaterSwapUtil.userSelectValues(vo.getMeetingMinutesOfficer()));
        vo.setMeetingMode(this.generaterSwapUtil.getDicName(vo.getMeetingMode(), "442613624519786501"));
        vo.setRepetitiveMode(this.generaterSwapUtil.getDicName(vo.getRepetitiveMode(), "442613995455643653"));
        vo.setEnabledMark(this.generaterSwapUtil.getDicName(vo.getEnabledMark(), "442956288201064517"));
        vo.setFilesPath(this.generaterSwapUtil.getFileNameInJson(vo.getFilesPath()));
        vo.setCreatorUserId(this.generaterSwapUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.generaterSwapUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setResourcePreparation(this.generaterSwapUtil.getDicName(vo.getResourcePreparation(), "442951278029438981"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        if (entity != null) {
            otMeetingRoomReservationUpForm.setLastModifyUserId(userInfo.getUserId());
            otMeetingRoomReservationUpForm.setLastModifyTime(DateUtil.getNow());
            OtMeetingRoomReservationEntity subentity = (OtMeetingRoomReservationEntity)JsonUtil.getJsonToBean((Object)otMeetingRoomReservationUpForm, OtMeetingRoomReservationEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            if (!MeetingConstants.MEETING_MODE.equals(subentity.getMeetingMode()) && MeetingConstants.PASS_ENABLEDMARK.equals(subentity.getEnabledMark())) {
                List userList = JsonUtil.getJsonToList((String)subentity.getParticipantsUserIds(), String.class);
                boolean sameDay = DateUtils.isSameDay((Date)subentity.getCreatorTime(), (Date)subentity.getStartTime());
                String url = "/#/pages/work-order/work-order-accept/index";
                if (sameDay) {
                    this.otMeetingRoomReservationService.sendMessage(userList, "\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bae\u9700\u8981\u53c2\u52a0", "content", url);
                }
            }
            this.otMeetingRoomReservationService.update(id, subentity);
            this.otMeetingRoomReservationService.scheduledupdateEnabledMark();
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/acceptOrRejectApplications"})
    public ActionResult acceptOrRejectApplications(@RequestBody OtMeetingRoomReservationUpForm otMeetingRoomReservationUpForm) throws IOException {
        OtMeetingRoomReservationEntity reservationEntity = this.otMeetingRoomReservationService.approveMeeting(otMeetingRoomReservationUpForm);
        if (MeetingConstants.ORIGINARY_MEETING.equals(reservationEntity.getMeetingMode()) && reservationEntity.getEnabledMark() == 30) {
            boolean sameDay;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(DateUtil.getNowDate());
            cal2.setTime(reservationEntity.getStartTime());
            boolean bl = sameDay = cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
            if (sameDay) {
                List<String> participantsUserIds = this.getParticipantsUserIds(reservationEntity.getParticipantsUserIds());
                String url = "/#/pages/work-order/work-order-accept/index";
                this.otMeetingRoomReservationService.sendMessage(participantsUserIds, "\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bae\u9700\u8981\u53c2\u52a0", reservationEntity.getMeetingTitle(), url);
            }
        }
        this.otMeetingRoomReservationService.update(reservationEntity.getId(), reservationEntity);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OtMeetingRoomReservationEntity entity = this.otMeetingRoomReservationService.getInfo(id);
        if (entity != null) {
            this.otMeetingRoomReservationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    public List<String> getParticipantsUserIds(String ids) {
        ArrayList<String> userIds = new ArrayList<String>();
        ids = ids.replaceAll("\"", "").replace("[", "").replace("]", "");
        String[] split = ids.split(",");
        List jsonToList = JsonUtil.getJsonToList((Object)split, String.class);
        userIds.addAll(jsonToList);
        return userIds;
    }
}

